/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.StringHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;

public final class NativeLibraryLoader {
    private static Class uriClass;
    private static Constructor uriConstructor;
    private static Constructor fileConstructor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    public static void loadLibrary(ClassLoader classLoader, String string) {
        File file = NativeLibraryLoader.getResource(classLoader, System.mapLibraryName(string));
        if (file == null) {
            System.loadLibrary(string);
        } else {
            System.load(file.getAbsolutePath());
        }
    }

    public static File getResource(ClassLoader classLoader, String string) {
        URL[] uRLArray;
        if (classLoader != null && (uRLArray = NativeLibraryLoader.mapUrlToFile(classLoader.getResource(string))) != null) {
            return uRLArray;
        }
        if (classLoader instanceof URLClassLoader) {
            uRLArray = ((URLClassLoader)classLoader).getURLs();
            int n = 0;
            while (n < uRLArray.length) {
                File file = NativeLibraryLoader.mapUrlToFile(uRLArray[n]);
                if (file != null) {
                    File file2;
                    File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
                    if (file2 != null) {
                        file = new File(file2, string);
                        if (file.exists()) {
                            return file;
                        }
                        if ((file2 = file2.getParentFile()) != null && (file = new File(file2, string)).exists()) {
                            return file;
                        }
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private NativeLibraryLoader() {
    }

    private static File mapUrlToFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (fileConstructor == null) {
            return uRL.getProtocol().equalsIgnoreCase("file") && uRL.getAuthority() == null && uRL.getQuery() == null && uRL.getRef() == null ? new File(URLDecoder.decode(StringHelper.replace(uRL.getPath(), '+', "%2B"))) : null;
        }
        try {
            Object t = uriConstructor.newInstance(uRL.toString());
            try {
                return (File)fileConstructor.newInstance(t);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof IllegalArgumentException) {
                    return null;
                }
                throw invocationTargetException;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("This cannot happen: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("This cannot happen: " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new RuntimeException("This cannot happen: " + invocationTargetException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            uriClass = Class.forName("java.net.URI");
            uriConstructor = uriClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = NativeLibraryLoader.class$("java.lang.String")) : class$java$lang$String);
            fileConstructor = (class$java$io$File == null ? (class$java$io$File = NativeLibraryLoader.class$("java.io.File")) : class$java$io$File).getConstructor(uriClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }
}

