/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class Tree
extends DescendantManager
implements Accessible {
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleSelection;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleAction;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleText;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleValue;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleImage;

    protected Tree(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected void setActiveDescendant(Accessible accessible) {
        Accessible accessible2 = this.activeDescendant;
        this.activeDescendant = accessible;
        this.firePropertyChange("AccessibleActiveDescendant", accessible2, accessible);
    }

    protected void setActiveDescendant(Object object) {
        TreeItem treeItem = null;
        try {
            XAccessible xAccessible;
            if (AnyConverter.isObject((Object)object) && (xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object)) != null) {
                treeItem = new TreeItem(xAccessible);
            }
            this.setActiveDescendant(treeItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void add(XAccessible xAccessible) {
        if (xAccessible != null) {
            this.firePropertyChange("AccessibleChild", null, new TreeItem(xAccessible));
        }
    }

    protected void remove(XAccessible xAccessible) {
        if (xAccessible != null) {
            this.firePropertyChange("AccessibleChild", new TreeItem(xAccessible), null);
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTreeListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTree();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TreeItem
    implements Accessible {
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext = null;

        public TreeItem(XAccessible xAccessible) {
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] objectArray) {
            try {
                ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>(objectArray.length);
                int n = 0;
                while (n < objectArray.length) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? Tree.class$("com.sun.star.accessibility.XAccessible") : class$com$sun$star$accessibility$XAccessible), (Object)objectArray[n]);
                    if (xAccessible != null) {
                        arrayList.add(new TreeItem(xAccessible));
                    }
                    ++n;
                }
                arrayList.trimToSize();
                return arrayList.toArray();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            block3: {
                if (this.accessibleContext != null) break block3;
                try {
                    AccessibleTreeItem accessibleTreeItem;
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null && (accessibleTreeItem = new AccessibleTreeItem(xAccessibleContext)) != null) {
                        accessibleTreeItem.setAccessibleParent(Tree.this);
                        this.accessibleContext = accessibleTreeItem;
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
            return this.accessibleContext;
        }

        protected class AccessibleTreeItem
        extends AccessibleContext
        implements AccessibleSelection {
            XAccessibleContext unoAccessibleContext;
            XAccessibleSelection unoAccessibleSelection;

            public AccessibleTreeItem(XAccessibleContext xAccessibleContext) {
                this.unoAccessibleContext = xAccessibleContext;
                this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleSelection == null ? (class$com$sun$star$accessibility$XAccessibleSelection = Tree.class$("com.sun.star.accessibility.XAccessibleSelection")) : class$com$sun$star$accessibility$XAccessibleSelection), (Object)xAccessibleContext);
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleName(String string) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleDescription(String string) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole accessibleRole = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    return accessibleRole != null ? accessibleRole : AccessibleRole.LABEL;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale locale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(locale.Language, locale.Country);
                }
                catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                    throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    return Tree.this.getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException runtimeException) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int n) {
                Accessible accessible = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    Accessible accessible2 = ((TreeItem)TreeItem.this).Tree.this.activeDescendant;
                    if (accessible2 instanceof TreeItem && ((TreeItem)accessible2).unoAccessible.equals(xAccessible)) {
                        accessible = accessible2;
                    } else if (xAccessible != null) {
                        accessible = new TreeItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {}
                return accessible;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                    accessibleStateSet.add(AccessibleState.TRANSIENT);
                    XAccessibleStateSet xAccessibleStateSet = this.unoAccessibleContext.getAccessibleStateSet();
                    if (xAccessibleStateSet.contains((short)7)) {
                        accessibleStateSet.add(AccessibleState.ENABLED);
                    }
                    if (xAccessibleStateSet.contains((short)19)) {
                        accessibleStateSet.add(AccessibleState.OPAQUE);
                    }
                    if (xAccessibleStateSet.contains((short)21)) {
                        accessibleStateSet.add(AccessibleState.RESIZABLE);
                    }
                    if (xAccessibleStateSet.contains((short)25)) {
                        accessibleStateSet.add(AccessibleState.SHOWING);
                    }
                    if (xAccessibleStateSet.contains((short)30)) {
                        accessibleStateSet.add(AccessibleState.VISIBLE);
                    }
                    if (xAccessibleStateSet.contains((short)26)) {
                        accessibleStateSet.add(AccessibleState.SINGLE_LINE);
                    }
                    if (xAccessibleStateSet.contains((short)17)) {
                        accessibleStateSet.add(AccessibleState.MULTI_LINE);
                    }
                    if (xAccessibleStateSet.contains((short)22)) {
                        accessibleStateSet.add(AccessibleState.SELECTABLE);
                    }
                    if (xAccessibleStateSet.contains((short)23)) {
                        accessibleStateSet.add(AccessibleState.SELECTED);
                    }
                    if (xAccessibleStateSet.contains((short)8)) {
                        accessibleStateSet.add(AccessibleState.EXPANDABLE);
                        if (xAccessibleStateSet.contains((short)9)) {
                            accessibleStateSet.add(AccessibleState.EXPANDED);
                        } else {
                            accessibleStateSet.add(AccessibleState.COLLAPSED);
                        }
                    }
                    return accessibleStateSet;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = Tree.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)this.unoAccessibleContext);
                    return xAccessibleComponent != null ? new AccessibleComponentImpl(xAccessibleComponent) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.unoAccessibleSelection != null ? this : null;
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleAction == null ? (class$com$sun$star$accessibility$XAccessibleAction = Tree.class$("com.sun.star.accessibility.XAccessibleAction")) : class$com$sun$star$accessibility$XAccessibleAction), (Object)this.unoAccessibleContext);
                    return xAccessibleAction != null ? new AccessibleActionImpl(xAccessibleAction) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                try {
                    XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = Tree.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText), (Object)this.unoAccessibleContext);
                    return xAccessibleText != null ? new AccessibleTextImpl(xAccessibleText) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleValue == null ? (class$com$sun$star$accessibility$XAccessibleValue = Tree.class$("com.sun.star.accessibility.XAccessibleValue")) : class$com$sun$star$accessibility$XAccessibleValue), (Object)this.unoAccessibleContext);
                    return xAccessibleValue != null ? new AccessibleValueImpl(xAccessibleValue) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage xAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleImage == null ? (class$com$sun$star$accessibility$XAccessibleImage = Tree.class$("com.sun.star.accessibility.XAccessibleImage")) : class$com$sun$star$accessibility$XAccessibleImage), (Object)this.unoAccessibleContext);
                    if (xAccessibleImage != null) {
                        AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{new AccessibleIconImpl(xAccessibleImage)};
                        return accessibleIconArray;
                    }
                }
                catch (RuntimeException runtimeException) {}
                return null;
            }

            public Accessible getAccessibleSelection(int n) {
                TreeItem treeItem = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    if (xAccessible != null) {
                        treeItem = new TreeItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {}
                return treeItem;
            }

            public void addAccessibleSelection(int n) {
                try {
                    this.unoAccessibleSelection.selectAccessibleChild(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {}
            }

            public void clearAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.clearAccessibleSelection();
                }
                catch (RuntimeException runtimeException) {}
            }

            public int getAccessibleSelectionCount() {
                try {
                    return this.unoAccessibleSelection.getSelectedAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            public boolean isAccessibleChildSelected(int n) {
                try {
                    return this.unoAccessibleSelection.isAccessibleChildSelected(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return false;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }

            public void removeAccessibleSelection(int n) {
                try {
                    this.unoAccessibleSelection.deselectAccessibleChild(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {}
            }

            public void selectAllAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.selectAllAccessibleChildren();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    protected class AccessibleTree
    extends DescendantManager.AccessibleDescendantManager {
        protected AccessibleTree() {
        }

        protected AccessibleStateSet getAccessibleStateSetImpl(XAccessibleStateSet xAccessibleStateSet) {
            AccessibleStateSet accessibleStateSet;
            block3: {
                accessibleStateSet = super.getAccessibleStateSetImpl(xAccessibleStateSet);
                try {
                    if (xAccessibleStateSet == null || !xAccessibleStateSet.contains((short)8)) break block3;
                    accessibleStateSet.add(AccessibleState.EXPANDABLE);
                    if (xAccessibleStateSet.contains((short)9)) {
                        accessibleStateSet.add(AccessibleState.EXPANDED);
                        break block3;
                    }
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
                catch (RuntimeException runtimeException) {}
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public Accessible getAccessibleChild(int n) {
            Accessible accessible;
            block4: {
                accessible = null;
                try {
                    XAccessible xAccessible = Tree.this.unoAccessibleContext.getAccessibleChild(n);
                    if (xAccessible == null) break block4;
                    Accessible accessible2 = Tree.this.activeDescendant;
                    if (accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible)) {
                        accessible = accessible2;
                        break block4;
                    }
                    accessible = new TreeItem(xAccessible);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {}
            }
            return accessible;
        }

        public Accessible getAccessibleSelection(int n) {
            Accessible accessible;
            block4: {
                accessible = null;
                try {
                    XAccessible xAccessible = Tree.this.unoAccessibleContext.getAccessibleChild(n);
                    if (xAccessible == null) break block4;
                    Accessible accessible2 = Tree.this.activeDescendant;
                    if (accessible2 instanceof TreeItem && xAccessible.equals(((TreeItem)accessible2).unoAccessible)) {
                        accessible = accessible2;
                        break block4;
                    }
                    accessible = new TreeItem(xAccessible);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {}
            }
            return accessible;
        }
    }

    protected class AccessibleTreeListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        protected AccessibleTreeListener() {
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 5: {
                    Tree.this.setActiveDescendant(accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        Tree.this.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    Tree.this.add(accessibleEventObject.NewValue);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

