/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility.logging;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;

public class XAccessibleTextLog
implements XAccessibleText {
    private XAccessibleText unoObject;
    private String name = "[Unknown] NoName";
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleContext;

    public XAccessibleTextLog(XAccessibleText xAccessibleText) {
        this.unoObject = xAccessibleText;
        this.setName(xAccessibleText);
    }

    private void setName(XAccessibleText xAccessibleText) {
        try {
            XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleContext == null ? (class$com$sun$star$accessibility$XAccessibleContext = XAccessibleTextLog.class$("com.sun.star.accessibility.XAccessibleContext")) : class$com$sun$star$accessibility$XAccessibleContext), (Object)xAccessibleText);
            if (xAccessibleContext != null) {
                this.name = "[" + AccessibleRoleAdapter.getAccessibleRole(xAccessibleContext.getAccessibleRole()) + "] " + xAccessibleContext.getAccessibleName() + ": ";
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    private String getPartString(short s) {
        String string = "INVALID";
        switch (s) {
            case 1: {
                string = "CHARACTER";
                break;
            }
            case 2: {
                string = "WORD";
                break;
            }
            case 3: {
                string = "SENTENCE";
                break;
            }
            case 5: {
                string = "LINE";
                break;
            }
            case 7: {
                string = "ATTRIBUTE_RUN";
                break;
            }
        }
        return string;
    }

    private String dumpTextSegment(TextSegment textSegment) {
        if (textSegment != null) {
            return "(" + textSegment.SegmentStart + "," + textSegment.SegmentEnd + "," + textSegment.SegmentText + ")";
        }
        return "NULL";
    }

    public boolean copyText(int n, int n2) throws IndexOutOfBoundsException {
        return this.unoObject.copyText(n, n2);
    }

    public int getCaretPosition() {
        int n = this.unoObject.getCaretPosition();
        System.err.println(this.name + "getCaretPosition() returns " + n);
        return n;
    }

    public char getCharacter(int n) throws IndexOutOfBoundsException {
        return this.unoObject.getCharacter(n);
    }

    public PropertyValue[] getCharacterAttributes(int n, String[] stringArray) throws IndexOutOfBoundsException {
        return this.unoObject.getCharacterAttributes(n, stringArray);
    }

    public Rectangle getCharacterBounds(int n) throws IndexOutOfBoundsException {
        try {
            Rectangle rectangle = this.unoObject.getCharacterBounds(n);
            System.err.println(this.name + "getCharacterBounds(" + n + ") returns (" + rectangle.X + "," + rectangle.Y + "," + rectangle.Width + "," + rectangle.Height + ")");
            return rectangle;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + "getCharacterBounds(" + n + ")");
            throw indexOutOfBoundsException;
        }
    }

    public int getCharacterCount() {
        return this.unoObject.getCharacterCount();
    }

    public int getIndexAtPoint(Point point) {
        try {
            int n = this.unoObject.getIndexAtPoint(point);
            System.err.println(this.name + "getIndexAtPoint(" + point.X + ", " + point.Y + ") returns " + n);
            return n;
        }
        catch (RuntimeException runtimeException) {
            System.err.println(this.name + "RuntimeException caught for getIndexAtPoint(" + point.X + ", " + point.Y + ")");
            System.err.println(runtimeException.getMessage());
            throw runtimeException;
        }
    }

    public String getSelectedText() {
        return this.unoObject.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.unoObject.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.unoObject.getSelectionStart();
    }

    public String getText() {
        return this.unoObject.getText();
    }

    public TextSegment getTextAtIndex(int n, short s) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            TextSegment textSegment = this.unoObject.getTextAtIndex(n, s);
            System.err.println(this.name + "getTextAtIndex(" + this.getPartString(s) + "," + n + ") returns " + this.dumpTextSegment(textSegment));
            return textSegment;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + " getTextAtIndex(" + this.getPartString(s) + "," + s + ")");
            throw indexOutOfBoundsException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("IllegalArgumentException caught for " + this.name + " getTextAtIndex(" + this.getPartString(s) + "," + n + ")");
            throw illegalArgumentException;
        }
    }

    public TextSegment getTextBeforeIndex(int n, short s) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            TextSegment textSegment = this.unoObject.getTextBeforeIndex(n, s);
            System.err.println(this.name + " getTextBeforeIndex(" + this.getPartString(s) + "," + n + ") returns " + this.dumpTextSegment(textSegment));
            return textSegment;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + " getTextBeforeIndex(" + this.getPartString(s) + "," + s + ")");
            throw indexOutOfBoundsException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("IllegalArgumentException caught for " + this.name + " getTextBeforeIndex(" + this.getPartString(s) + "," + n + ")");
            throw illegalArgumentException;
        }
    }

    public TextSegment getTextBehindIndex(int n, short s) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            TextSegment textSegment = this.unoObject.getTextBehindIndex(n, s);
            System.err.println(this.name + " getTextBehindIndex(" + this.getPartString(s) + "," + n + ") returns " + this.dumpTextSegment(textSegment));
            return textSegment;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + " getTextBehindIndex(" + this.getPartString(s) + "," + s + ")");
            throw indexOutOfBoundsException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("IllegalArgumentException caught for " + this.name + " getTextBehindIndex(" + this.getPartString(s) + "," + n + ")");
            throw illegalArgumentException;
        }
    }

    public String getTextRange(int n, int n2) throws IndexOutOfBoundsException {
        return this.unoObject.getTextRange(n, n2);
    }

    public boolean setCaretPosition(int n) throws IndexOutOfBoundsException {
        return this.unoObject.setCaretPosition(n);
    }

    public boolean setSelection(int n, int n2) throws IndexOutOfBoundsException {
        return this.unoObject.setSelection(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

