/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.Permission;
import java.util.Vector;

public final class PermissionCollection {
    private Vector permissions = new Vector();

    public PermissionCollection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("PermissionCollection");
        }
    }

    public PermissionCollection(PermissionCollection permissionCollection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("PermissionCollection");
        }
        this.permissions = (Vector)permissionCollection.permissions.clone();
    }

    public void reset() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("PermissionCollection");
        }
        this.permissions.removeAllElements();
    }

    public void add(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("PermissionCollection");
        }
        this.permissions.addElement(permission);
    }

    public boolean implies(Permission permission) {
        boolean bl = false;
        for (int i = 0; i < this.permissions.size() && !bl; ++i) {
            bl = ((Permission)this.permissions.elementAt(i)).implies(permission);
        }
        return bl;
    }
}

