/*
 * Anthyǥ 
 *
 * ܤmetaword礷ƤȤˤ깽ʸڤ
 * 
 * (1)ܸʥǥȤ
 * (2)׻̤ȯޤ
 *
 * Copyright (C) 2003-2004 TABATA Yusuke
 */
#include <splitter.h>
#include "wordborder.h"

/* 줿meta_word */
static struct meta_word *hl_mws;

void
anthy_init_segclass(struct seg_class *sc)
{
  sc->head_pos = POS_NONE;
  sc->tail_pos = POS_NONE;
  sc->tail_ct = CT_NONE;
  sc->tail_type = SEG_NONE;
}

static void
do_combine(struct splitter_context *sc, int type,
	   struct meta_word *mw1, struct meta_word *mw2)
{
  struct meta_word *res;
  res = anthy_do_combine_metaword(sc, type,
				  mw1, mw2);
  res->mw_count = mw1->mw_count + mw2->mw_count;
  res->seg_class = mw2->seg_class;
  if (0) {
    anthy_print_metaword(sc, res);
  }
  /* Ѥߤmeta_wordlistɲä */
  res->composed = hl_mws;
  hl_mws = res;
  /* balanceʬŬʤΤǡΤ׻ʤ */
  res->score -= 400;
}

/* ֡ϡס֡ */
static void
try_combine_subject(struct splitter_context *sc,
		    struct meta_word *mw1, struct meta_word *mw2)
{
  if ((mw2->seg_class.tail_type & SEG_INDECLINABLE) ||
      (mw2->seg_class.tail_type & SEG_DECLINABLE)) {
    do_combine(sc, MW_SENTENCE,
	       mw1, mw2);
  }
}

/* ֡ʡס֡ΡϢλ Ϣ*/
static void
try_combine_rt_modifier(struct splitter_context *sc,
			struct meta_word *mw1, struct meta_word *mw2)
{
  if (mw2->seg_class.tail_type & SEG_SUBJECT) {
    do_combine(sc, MW_MODIFIED,
	       mw1, mw2);
  }
  if (mw2->seg_class.head_pos == POS_NOUN) {
    do_combine(sc, MW_MODIFIED,
	       mw1, mw2);
  }
}

/* ֡ */
static void
try_combine_wo(struct splitter_context *sc,
	       struct meta_word *mw1, struct meta_word *mw2)
{
  if (mw2->seg_class.tail_type & SEG_INDECLINABLE) {
    do_combine(sc, MW_MODIFIED,
	       mw1, mw2);
  }
}

/* ֡ȡ */
static void
try_combine_to(struct splitter_context *sc,
	       struct meta_word *mw1, struct meta_word *mw2)
{
  if (mw2->seg_class.head_pos == POS_V) {
    do_combine(sc, MW_MODIFIED,
	       mw1, mw2);
  }
}

/*  */
static void
try_combine_adverb(struct splitter_context *sc,
		   struct meta_word *mw1, struct meta_word *mw2)
{
  if (mw2->seg_class.tail_type & SEG_MODIFIER_TO) {
    do_combine(sc, MW_MODIFIED, mw1, mw2);
  }
}
/* Ϣη */
static void
try_combine_rentai(struct splitter_context *sc,
		   struct meta_word *mw1, struct meta_word *mw2)
{
  if (mw2->seg_class.head_pos & POS_NOUN) {
    do_combine(sc, MW_MODIFIED, mw1, mw2);
  }
}

/** Ϣܤmeta_wordФơ¦meta_wordΥѥ˱
    */
static void
try_combine(struct splitter_context *sc,
	    struct meta_word *mw1, struct meta_word *mw2)
{
  if (mw1->seg_class.tail_type & SEG_SUBJECT) {
    //try_combine_subject(sc, mw1, mw2);
  }
  if (mw1->seg_class.tail_type & SEG_RT_MODIFIER) {
    try_combine_rt_modifier(sc, mw1, mw2);
  }
  if (mw1->seg_class.tail_type & SEG_MODIFIER_WO) {
    try_combine_wo(sc, mw1, mw2);
  }
  if (mw1->seg_class.tail_type & SEG_MODIFIER_TO) {
    try_combine_to(sc, mw1, mw2);
  }
  if (mw1->seg_class.tail_type & SEG_ADVERB) {
    try_combine_adverb(sc, mw1, mw2);
  }
  if (mw1->seg_class.tail_ct == CT_RENTAI) {
    try_combine_rentai(sc, mw1, mw2);
  }
}

/**/
void
anthy_make_syntactic_metaword(struct splitter_context *sc)
{
  int i, right;
  struct word_split_info_cache *info = sc->word_split_info;
  struct meta_word *mw, *mw2;
  /**/
  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_S) {
    return ;
  }
  return ;
  hl_mws = 0;
  /* Υ롼פmetaword.ccombine_metaword()Ʊ */
  for (i = 0; i < sc->char_count; i++){
    for (mw = info->cnode[i].mw;
	 mw; mw = mw->next) {
      if (mw->len + i == sc->char_count) {
	continue;
      }
      for (mw2 = info->cnode[mw->len+i].mw; 
	   mw2; mw2 = mw2->next) {
	/* mwmw2ηtry */
	try_combine(sc, mw, mw2);
      }
    }
  }
  /* meta_wordФ */
  for (mw = hl_mws; mw; mw = mw->composed) {
    right = mw->from + mw->len;
    if (right == sc->char_count) {
      continue ;
    }
    for (mw2 = info->cnode[right].mw; mw2; mw2 = mw2->next) {
      try_combine(sc, mw, mw2);
    }
  }
}
