// -*- C++ -*-
#define USE_WITHDRAWN
#ifndef _jmode_h_included_
#define _jmode_h_included_

#include <stdio.h>

#include <list>
#include <vector>

void read_conf_file();
char *my_getenv(char *);

bool pretrans_register();
int pretrans_setup();

int connection_setup();
void sock_proc(int fd, int event); // event is READ_OK or WRITE_OK

// fd dispatch
#define READ_OK 1
#define WRITE_OK 2

class Dispatcher {
public:
    virtual void addFDWatch(int fd, int mask, void (*f)(int, int)) = 0;
    virtual void removeFDWatch(int fd) = 0;
    virtual void mainLoop() = 0;
};

Dispatcher *get_dispatcher();

//ѴΥݡ
// jstring ʸ

// preeditν
#define PE_NORMAL 0
#define PE_REVERSE 1
#define PE_UNDERLINE 2
#define PE_HILIGHT 4

typedef int cchar;
typedef std::list<cchar> jstring_t;
struct pe_jstring{
    jstring_t s;
    int stat;
};

struct Candidates;
class KKContext;
// ˴KKContextΥ󥹥ȥ饯ǥȥ饯ǹԤʤ
class pe_stat{
public:
    pe_stat(KKContext *);
    void clear();
    void new_segment(int s);
    void push_cchar(cchar );
    int get_char_count();
    std::list<pe_jstring> jstrings; //ʸڤ줿Ρ
    Candidates *cands;
    KKContext *cont;
};

void print_jstring(jstring_t *s);
void erase_jstring(jstring_t *s);
void append_jstring(jstring_t *d,jstring_t *s);
void str_to_jstring(jstring_t *d,char *s);// JIS or EUC
char *jstring_to_str(jstring_t *s);// EUCȤ֤äƤ롣

// global cut buffer
void paste_from_global_buffer(jstring_t *s);
void copy_to_global_buffer(jstring_t *s);

//
class KKConv;
void init_preconf_kkconv();
KKConv *init_kkconv();
void free_kkconv();

void global_finalize(int );


// 桼󥿡եȤ
void init_toolkit(int *argc,char ***argv);
void init_ui(KKConv *);
void show_issue(char *);
void init_convdisp();
void ui_update_ic_stat();
void ui_update_input_mode(int );

// Control Command
void init_ctrl();
void ui_ctrl_command(char *);
void kk_ctrl_command(char *);
// misc
int pad4(int );


// key bindȤΤ
class CAtom;
typedef CAtom *atom_t;

void init_default_atoms();
void add_conf_hook(char *, void (*fn)(char *));
atom_t get_atom_by_name(char *name);
void bind_atom(atom_t from,atom_t to);
void bind_str_to_atom(char *s,atom_t);
bool is_bind_to(atom_t from,atom_t to);
char *get_atom_name(atom_t );
atom_t get_bound_atoms(atom_t to,atom_t c);
int nr_bound_atoms(atom_t to);

// debug functions
void hex_dump(unsigned char *buf,int len);


// ưץ󡢼˵ưΥޥɥ饤󥪥ץǷޤ롣
// 饤ȤȤΤפ
#define OPT_TRACE 1
// XIM̿פ
#define OPT_TRACE_XIM 2
#define OPT_POPUP 8
#define OPT_ISSUE 16
#define OPT_TOOLBAR 32
#ifdef USE_WITHDRAWN
#define OPT_WITHDRAWN 64
#endif


// byte order
#define BYTEORDER_UNKNOWN 0
#define LSB_FIRST 1
#define MSB_FIRST 2


// 
extern int host_byte_order;
extern int g_option_mask;
extern int uid;
extern char *homedir;
extern int scr_width,scr_height;
extern int ctrl_fd_r, ctrl_fd_w;
extern FILE *ctrl_in,*ctrl_out;

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
