dnl acinclude.m4 for HekeIM.
dnl    Written by TAKAI Kousuke <tak@kmc.gr.jp>

dnl HEKE_TYPE_SOCKLEN_T, HEKE_FUNC_SETSOCKOPT_ARGTYPES(),HEKE_CHECK_DECL()
dnl are no longer needed, because jmode does not use TCP for XIM connection
dnl These should be removed in near future.
dnl  May 8 2001 Yusuke Tabata <tabata@utena.org>

dnl HEKE_TYPE_SOCKLEN_T()
dnl
dnl   Similar to AC_CHECK_TYPE, but it cannot check header files other
dnl   than sys/types.h.
dnl
AC_DEFUN(HEKE_TYPE_SOCKLEN_T,
[AC_CACHE_CHECK([for socklen_t], heke_cv_type_socklen_t,
[AC_EGREP_CPP(changequote(<<,>>)dnl
<<(^|[^a-zA-Z_0-9])socklen_t([^a-zA-Z_0-9]|$)>>changequote([,]),
[#include <sys/types.h>
#include <sys/socket.h>],
heke_cv_type_socklen_t=yes, heke_cv_type_socklen_t=no)])
test "$heke_cv_type_socklen_t" = yes || AC_DEFINE(socklen_t, int, [type of socklen_t])])

dnl HEKE_FUNC_SETSOCKOPT_ARGTYPES()
dnl
dnl	Inspired by AC_FUNC_SELECT_ARGTYPES in autoconf/acspecific.m4.
dnl	This must come after HEKE_TYPE_SOCKLEN_T.
dnl
AC_DEFUN(HEKE_FUNC_SETSOCKOPT_ARGTYPES,
[AC_MSG_CHECKING(type of 4th argument for setsockopt)
AC_CACHE_VAL(heke_cv_func_setsockopt_arg4,
[for heke_cv_func_setsockopt_arg4 in 'const void *' 'void *' 'const char *' 'char *' .; do
  test "$heke_cv_func_setsockopt_arg4" = . && break
  AC_TRY_COMPILE([#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef __cplusplus
extern "C" {
#endif
extern int setsockopt (int, int, int, $heke_cv_func_setsockopt_arg4, socklen_t);
#ifdef __cplusplus
}
#endif],, break)
done])dnl AC_CACHE_VAL
if test "$heke_cv_func_setsockopt_arg4" = .; then
  # This is the last resort.
  heke_value='char *'
  heke_msg='unknown, assuming char *'
else
  heke_value="$heke_cv_func_setsockopt_arg4"
  heke_msg="$heke_cv_func_setsockopt_arg4"
fi
AC_MSG_RESULT($heke_msg)
AC_DEFINE_UNQUOTED(SETSOCKOPT_TYPE_ARG4, $heke_value, [type of 4th argument of setsockopt])])

dnl HEKE_CHECK_DECL(INCLUDES, SYMBOL)
dnl
dnl	Check whether the external symbol SYMBOL is declared.
dnl	INCLUDES will be put before reference of SYMBOL.
dnl
AC_DEFUN(HEKE_CHECK_DECL,
[AC_CACHE_CHECK([whether $2 is declared], heke_cv_decl_$2,
[AC_TRY_COMPILE([$1], [return (void *) &$2 == (void *) 0],
	heke_cv_decl_$2=yes, heke_cv_decl_$2=no)])
test "$heke_cv_decl_$2" = yes && AC_DEFINE(translit($2, [a-z], [A-Z])_DECLARED,
	1, [Define if $2 is declared in header files.])])

dnl HEKE_CHECK_GNOME_APPLETS()
dnl    Written by Yusuke Tabata <yusuke@kmc.gr.jp>
AC_DEFUN([HEKE_CHECK_GNOME_APPLETS],[
  AC_MSG_CHECKING(for gnome)
  gnome-config --help > /dev/null || {
    echo "can't find gnome-config." 1>&2
    exit 1
  }
  GNOME_APPLET_CFLAGS="`gnome-config --cflags applets`"
  GNOME_APPLET_LIBS="`gnome-config --libs applets`"
  AC_SUBST(GNOME_APPLET_CFLAGS)
  AC_SUBST(GNOME_APPLET_LIBS)
  AC_MSG_RESULT(yes)
])
