// $Id: CEnvironment.h,v 1.12 2003/04/23 09:20:55 ta_muto Exp $
// The class which manages the environment which a script performs.

#ifndef __wax_CEnvironment_h
#define __wax_CEnvironment_h

#include <common.h>
#include <IReader.h>
#include <CRequest.h>

namespace wax {
	class CEnvironment {
		xmlChar* scriptPath;
		
		xmlDocPtr doc;
		xmlNodePtr root;
		
		CRequest* request;
		bool startFlag;
	public:
		CEnvironment(CRequest* req, bool initFlag = true);
		~CEnvironment();
		
		xmlDocPtr getDocPtr() const { return doc; }
		xmlNodePtr getRootNodePtr() const { return root; }
		
		CRequest* getRequest() const { return request; }
		bool getStartFlag() const { return startFlag; }
		const xmlChar* getScriptPath() const { return scriptPath; }

		IReader* getReader(const xmlChar* href);
		xmlChar* makePath(const xmlChar* path);
		
		bool prepare(const xmlChar* targetPath);
	public:
		static const xmlChar* WAX;
		static const xmlChar* XUPDATE;
		static const xmlChar* XMLSCHEMA;
	} ;
}

#endif
