// $Id: CStdError.cc,v 1.3 2003/04/17 06:29:55 ta_muto Exp $

#include <CStdError.h>

namespace wax {
	class CErrorItem : public ICursor {
		int errorCode;
		char* message;
		char* remarks;
	public:
		CErrorItem(int errorCode, const char* initMsg, const char* initRemarks);
		~CErrorItem();
		
		const int getErrorCode() const { return errorCode; }
		const char* getMessage() const { return message; }
		const char* getRemarks() const { return remarks; }
	} ;
}

wax::CErrorItem::CErrorItem(int initCode, const char* initMsg, const char* initRemarks)
{
	errorCode = initCode;
	if(initMsg != NULL) {
		message = new char[strlen(initMsg) + 1];
		strcpy(message, initMsg);
	} else {
		message = NULL;
	}
	if(initRemarks != NULL) {
		remarks = new char[strlen(initRemarks) + 1];
		strcpy(remarks, initRemarks);
	} else {
		remarks = NULL;
	}
}

wax::CErrorItem::~CErrorItem()
{
	if(message != NULL)	delete [] message;
	if(remarks != NULL)	delete [] remarks;
}

void wax::CStdError::write(int errorCode, const char* message, const char* remarks)
{
	errors.addItem(new CErrorItem(errorCode, message, remarks));
}

void wax::CStdError::flush()
{
	writer->writeStr("Content-type: text/html\n\n");
	writer->writeStr("<html><head><title>info-db Wax Error Reports</title></head>");
	writer->writeStr("<body>\n");

	CErrorItem* item = (CErrorItem*)errors.getHead();
	while(item != NULL) {
		if(item->getMessage() != NULL) {
			writer->writeStr(item->getMessage());
		}
		if(item->getRemarks() != NULL) {
			writer->writeStr("(");
			writer->writeHTMLEncodeChar(item->getRemarks());
			writer->writeStr(")");
		}
		writer->writeStr("<br />\n");
		item = (CErrorItem*)item->getNext();
	}
	writer->writeStr("</body></html>\n");
}
