// $Id: CXUAppend.cc,v 1.5 2003/05/10 06:46:51 ta_muto Exp $

#include <xupdate/CXUAppend.h>
#include <xupdate/CXUActionBase.h>

wax::CXUAppend::CXUAppend(const xmlChar* initConnect)
{
	select = NULL;
	child = NULL;
	if(initConnect != NULL) {
		connect = xmlStrdup(initConnect);
	} else {
		connect = NULL;
	}
	instanceData = NULL;
}

wax::CXUAppend::~CXUAppend()
{
	if(select != NULL)	xmlFree(select);
	if(child != NULL)	xmlFree(child);
	if(connect != NULL)	xmlFree(connect);
	if(instanceData != NULL)	xmlFreeDoc(instanceData);
}

bool wax::CXUAppend::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	select = CXUActionBase::getSelect(cur);
	if(select == NULL)	return false;

	child = xmlGetProp(cur, (const xmlChar*) "child");

	instanceData = CXUActionBase::parse(runenv, cur, vars, connect);
	if(connect == NULL) {
		IError::message(ERR_CONNECT);
		return false;
	}
	
	if(instanceData == NULL)	return false;
	return true;
}

bool wax::CXUAppend::execute(CXmlSession* session)
{
	IXmlDB* db = session->getInstance(connect);
	if(db == NULL) {
		return false;
	}
	if(db->select(select) == false) {
		return false;
	}
	if(db->append(instanceData, child) == false) {
		return false;
	}
	return true;
}
