// $Id: CXmlSession.cc,v 1.3 2003/04/23 09:21:01 ta_muto Exp $

#include <xupdate/CXmlSession.h>
#include <xupdate/CInterXmlDB.h>
#include <CRequest.h>

wax::CXmlSession::CXmlSession()
{
}

wax::CXmlSession::~CXmlSession()
{
	rollback();
}

wax::IXmlDB* wax::CXmlSession::getInstance(const xmlChar* connect)
{
	IXmlDB* cur = (IXmlDB*)sessions.getHead();
	while(cur != NULL) {
		if(cur->isMatch(connect) == true)	return cur;
		cur = (IXmlDB*)cur->getNext();
	}

	IXmlDB* db = newInstance(connect);
	if(db == NULL)	return NULL;
	add(db);
	CParameterItem* item = (CParameterItem*) vars.getHead();
	while(item != NULL) {
		db->registerVariable(item->getName(), item->getOriginalValue());
		item = (CParameterItem*) item->getNext();
	}
	return db;
}

void wax::CXmlSession::commit()
{
	IXmlDB* cur = (IXmlDB*)sessions.getHead();
	while(cur != NULL) {
		cur->flush();
		cur = (IXmlDB*)cur->getNext();
	}
	sessions.removeAll();
}

void wax::CXmlSession::rollback()
{
	IXmlDB* cur = (IXmlDB*)sessions.getHead();
	while(cur != NULL) {
		cur->close();
		cur = (IXmlDB*)cur->getNext();
	}
	sessions.removeAll();
}

wax::IXmlDB* wax::CXmlSession::newInstance(const xmlChar* connect)
{
	IXmlDB* db = new CInterXmlDB();
	if(db->open(connect) == false) {
		delete db;
		return NULL;
	}
	return db;
}

wax::CXmlSession* wax::CXmlSession::clone()
{
	return new CXmlSession();
}

wax::CXmlSession* factory = NULL;

wax::CXmlSession* wax::CXmlSession::getSession()
{
	if(factory != NULL) {
		return factory->clone();
	}
	return new CXmlSession();
}

void wax::CXmlSession::setSession(CXmlSession* mySession)
{
	factory = mySession;
}
