// $Id: IReader.h,v 1.4 2003/04/08 13:54:15 ta_muto Exp $
// Abstruct I/O Class

#ifndef __wax_IReader_h
#define __wax_IReader_h

#include <common.h>

namespace wax {
	class IReader {
	public:
		IReader(const xmlChar* initPath) { path = xmlStrdup(initPath); }
		virtual ~IReader();
		
		virtual bool open() = 0;
		virtual int read(char* buffer, int size) = 0;
		virtual void close() = 0;
		
		const xmlChar* getPath() const { return path; }
	protected:
		xmlChar* path;
	} ;
}

#endif
