/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.infodb.commons.xml.ElementWalker;
import org.infodb.commons.xml.WalkerHelper;
import org.infodb.commons.xml.XmlBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class UniversalElement
implements ElementWalker,
XmlBuilder {
    protected String elemName;
    protected HashMap<String, String> attrMap = new HashMap();
    protected ArrayList<Object> elemList = new ArrayList();

    @Override
    public void startElement(WalkerHelper walker) throws SAXException {
        this.elemName = walker.getQName();
        Attributes attrs = walker.getAttributes();
        int leng = attrs.getLength();
        for (int i = 0; i < leng; ++i) {
            String qName = attrs.getQName(i);
            String value = attrs.getValue(i);
            this.attrMap.put(qName, value);
        }
    }

    @Override
    public void endElement(WalkerHelper walker) throws SAXException {
    }

    @Override
    public void characters(WalkerHelper walker, String value) throws SAXException {
        this.elemList.add(value);
    }

    @Override
    public void action(WalkerHelper child) throws SAXException {
        this.elemList.add(child.getWalker());
    }

    @Override
    public void buildXml(ContentHandler saxHandler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (Map.Entry<String, String> entry : this.attrMap.entrySet()) {
            attrs.addAttribute("", "", entry.getKey(), "CDATA", entry.getValue());
        }
        saxHandler.startElement("", this.elemName, this.elemName, attrs);
        for (Object obj : this.elemList) {
            if (obj instanceof XmlBuilder) {
                ((XmlBuilder)obj).buildXml(saxHandler);
                continue;
            }
            if (obj instanceof String) {
                String val = obj.toString();
                saxHandler.characters(val.toCharArray(), 0, val.length());
                continue;
            }
            throw new SAXException("Unknown Element[[" + obj.toString() + "]]");
        }
        saxHandler.endElement("", this.elemName, this.elemName);
    }
}

