/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.infodb.commons.db.SQLRecord;
import org.infodb.commons.db.SQLRecordFactory;

public class SQLResultSet {
    private ResultSet rs;

    public SQLResultSet(ResultSet r) {
        this.rs = r;
    }

    public boolean next(SQLRecord record) throws SQLException {
        boolean rc = this.rs.next();
        if (rc) {
            record.copyFrom(this.rs);
        }
        return rc;
    }

    public void list(List<SQLRecord> list, SQLRecordFactory factory) throws SQLException {
        while (this.rs.next()) {
            SQLRecord record = factory.newInstance();
            record.copyFrom(this.rs);
            list.add(record);
        }
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

