/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.infodb.commons.db.SQLLog;
import org.infodb.commons.db.SQLTable;
import org.infodb.commons.db.SQLWhere;

public class SQLSelect {
    private Connection conn;
    private PreparedStatement stmt;
    private boolean needClose;
    private ArrayList<String> columns;
    private ArrayList<Object> colParams;
    private ArrayList<SQLWhere> whereClause;
    private SQLTable table;
    private String orderBy;
    private String groupBy;
    private String having;
    private boolean distinct;
    private boolean forUpdate;
    private int maxRows;

    public SQLSelect(Connection c) {
        this.conn = c;
        this.needClose = true;
        this.init();
    }

    public SQLSelect(Connection c, boolean close) {
        this.conn = c;
        this.needClose = close;
        this.init();
    }

    private void init() {
        this.columns = new ArrayList();
        this.colParams = new ArrayList();
        this.whereClause = new ArrayList();
        this.orderBy = null;
        this.groupBy = null;
        this.having = null;
        this.distinct = false;
        this.forUpdate = false;
    }

    public Connection getConnection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execute() throws SQLException {
        StringBuffer sb = new StringBuffer("SELECT ");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        boolean first = true;
        for (String colName : this.columns) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(colName);
            first = false;
        }
        sb.append(" FROM ");
        if (this.table == null) {
            throw new SQLException("table object was invalid.");
        }
        sb.append(this.table.toString());
        first = true;
        for (SQLWhere where : this.whereClause) {
            sb.append(where.getWhereString(first));
            first = false;
        }
        if (this.groupBy != null) {
            sb.append(" GROUP BY ");
            sb.append(this.groupBy);
        }
        if (this.having != null) {
            sb.append(" HAVING ");
            sb.append(this.having);
        }
        if (this.orderBy != null) {
            sb.append(" ORDER BY ");
            sb.append(this.orderBy);
        }
        if (this.forUpdate) {
            sb.append(" FOR UPDATE");
        }
        String sql = sb.toString();
        long handler = SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
        int index = 1;
        for (Object obj : this.colParams) {
            SQLLog.paramlog(index, obj.toString());
            this.stmt.setObject(index++, obj);
        }
        for (SQLWhere where : this.whereClause) {
            for (Object obj : where.getObjects()) {
                if (obj == null) continue;
                SQLLog.wherelog(index, obj.toString());
                this.stmt.setObject(index++, obj);
            }
        }
        if (this.maxRows > 0) {
            this.stmt.setMaxRows(this.maxRows);
        }
        try {
            ResultSet resultSet = this.stmt.executeQuery();
            return resultSet;
        }
        finally {
            SQLLog.deltaLog(handler);
        }
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.needClose) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void addColumn(String colName) {
        this.columns.add(colName);
    }

    public void addColumn(String colName, Object ... argsObj) {
        this.columns.add(colName);
        for (Object object : argsObj) {
            this.colParams.add(object);
        }
    }

    public void addWhere(SQLWhere where) {
        this.whereClause.add(where);
    }

    public SQLTable setTableName(String initTableName) {
        this.table = new SQLTable(initTableName);
        return this.table;
    }

    public void setDistinct(boolean initDistinct) {
        this.distinct = initDistinct;
    }

    public void setOrderBy(String initOrderBy) {
        this.orderBy = initOrderBy;
    }

    public void setGroupBy(String initGroupBy) {
        this.groupBy = initGroupBy;
    }

    public void setHaving(String initHaving) {
        this.having = initHaving;
    }

    public void setForUpdate(boolean initForUpdate) {
        this.forUpdate = initForUpdate;
    }

    public void setMaxRows(int rows) {
        this.maxRows = rows;
    }
}

