/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.xml;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.infodb.commons.xml.ElementWalker;
import org.infodb.commons.xml.Owner;
import org.infodb.commons.xml.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WalkerHelper {
    private Owner owner;
    private WalkerHelper top;
    private WalkerHelper parent;
    private ElementWalker walker;
    private String uri;
    private String localName;
    private String qName;
    private Attributes attrs;
    public static final String UNEXPECTED_TAG = "UNEXPECTED_TAG";
    public static final String UNKNOWN_CHILD_TAG = "UNKNOWN_CHILD_TAG";
    private static ResourceBundle msgs = ResourceBundle.getBundle("org.infodb.commons.xml.Messages");

    protected WalkerHelper() {
    }

    protected void init(Owner o, WalkerHelper t, WalkerHelper p, ElementWalker w) {
        this.top = t;
        this.parent = p;
        this.walker = w;
        this.owner = o;
    }

    public ElementWalker getWalker() {
        return this.walker;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public WalkerHelper getTop() {
        return this.top;
    }

    public WalkerHelper getParent() {
        return this.parent;
    }

    public String getURI() {
        return this.uri;
    }

    protected String getLocalName() {
        return this.localName;
    }

    public String getQName() {
        return this.qName;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public String getAttribute(String name, String defValue) {
        String val = this.attrs.getValue(name);
        if (val == null) {
            return defValue;
        }
        return val;
    }

    public int getAttribute(String name, int defValue) {
        String val = this.getAttribute(name, null);
        if (val == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            Parser.log.warn((Object)e.getMessage(), (Throwable)e);
            return defValue;
        }
    }

    public Integer getAttributeInt(String name, Integer defValue) {
        String val = this.getAttribute(name, null);
        if (val == null) {
            return defValue;
        }
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            Parser.log.warn((Object)e.getMessage(), (Throwable)e);
            return defValue;
        }
    }

    public boolean getAttribute(String name, boolean defValue) {
        String val = this.getAttribute(name, null);
        if (val == null) {
            return defValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("yes")) {
            return true;
        }
        if (val.equals("false") || val.equals("no")) {
            return false;
        }
        return defValue;
    }

    protected void startElement(String ns, String l, String q, Attributes a) throws SAXException {
        this.uri = ns;
        this.localName = l;
        this.qName = q;
        this.attrs = a;
        this.walker.startElement(this);
    }

    protected void endElement(String uri, String localName, String qName) throws SAXException {
        this.walker.endElement(this);
        if (this.getParent() != null) {
            this.getParent().getWalker().action(this);
        }
    }

    protected void characters(String value) throws SAXException {
        this.walker.characters(this, value);
    }

    public String getExceptionMessage(String name) {
        return MessageFormat.format(msgs.getString(name), this.qName);
    }
}

