/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLLog {
    private static Log log = LogFactory.getLog((String)"org.infodb.commons.db");

    public static long sqllog(String sql) {
        if (log.isDebugEnabled()) {
            Date dt = new Date();
            StringBuffer sb = new StringBuffer("sql:(");
            sb.append(dt.getTime());
            sb.append("):");
            sb.append(sql.replace("\n", " ").replace("\t", " "));
            log.debug((Object)sb.toString());
            return dt.getTime();
        }
        return 0L;
    }

    public static void paramlog(int index, String param) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("sql:param" + index + ":" + param));
        }
    }

    public static void wherelog(int index, String where) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("sql:where" + index + ":" + where));
        }
    }

    public static void error(Throwable t) {
        log.error((Object)t.getMessage(), t);
    }

    public static void deltaLog(long handler) {
        if (log.isDebugEnabled()) {
            Date dt = new Date();
            long delta = dt.getTime() - handler;
            log.debug((Object)("sql:(" + handler + "):Execution Time=" + delta + "ms"));
        }
    }
}

