/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, Canvas.checkStyle(n));
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.drawBackground(gC, n, n2, n3, n4, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    @Override
    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        int n3;
        if (this.ime != null && (n3 = this.ime.gtk_button_press_event(n, n2)) != 0) {
            return n3;
        }
        return super.gtk_button_press_event(n, n2);
    }

    @Override
    int gtk_commit(int n, int n2) {
        int n3;
        if (this.ime != null && (n3 = this.ime.gtk_commit(n, n2)) != 0) {
            return n3;
        }
        return super.gtk_commit(n, n2);
    }

    @Override
    int gtk_draw(int n, int n2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        int n3 = super.gtk_draw(n, n2);
        if (bl) {
            this.caret.setFocus();
        }
        return n3;
    }

    @Override
    int gtk_expose_event(int n, int n2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        int n3 = super.gtk_expose_event(n, n2);
        if (bl) {
            this.caret.setFocus();
        }
        return n3;
    }

    @Override
    int gtk_focus_in_event(int n, int n2) {
        int n3 = super.gtk_focus_in_event(n, n2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return n3;
    }

    @Override
    int gtk_focus_out_event(int n, int n2) {
        int n3 = super.gtk_focus_out_event(n, n2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return n3;
    }

    @Override
    int gtk_preedit_changed(int n) {
        int n2;
        if (this.ime != null && (n2 = this.ime.gtk_preedit_changed(n)) != 0) {
            return n2;
        }
        return super.gtk_preedit_changed(n);
    }

    @Override
    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (bl4) {
            this.caret.setFocus();
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n3, n4, n5, n6));
        this.scrollInPixels(point.x, point.y, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    void scrollInPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Control control;
        Object object;
        int n7;
        int n8;
        boolean bl2;
        int n9;
        if ((this.style & 0x8000000) != 0) {
            n9 = this.getClientWidth();
            n3 = n9 - n5 - n3;
            n = n9 - n5 - n;
        }
        n9 = n - n3;
        int n10 = n2 - n4;
        if (n9 == 0 && n10 == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        int n11 = this.paintWindow();
        int n12 = OS.GTK3 ? OS.gdk_window_get_visible_region(n11) : OS.gdk_drawable_get_visible_region(n11);
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n3;
        gdkRectangle.y = n4;
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            n8 = 0;
            n7 = 0;
            if (OS.GTK_IS_SCROLLED_WINDOW(this.scrolledHandle)) {
                n8 = OS.gtk_scrolled_window_get_hscrollbar(this.scrolledHandle);
                n7 = OS.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
            }
            object = new GtkRequisition();
            if (n8 != 0) {
                this.gtk_widget_get_preferred_size(n8, (GtkRequisition)object);
                if (((GtkRequisition)object).height > 0) {
                    gdkRectangle.y = n4 - ((GtkRequisition)object).height;
                }
            }
            if (n7 != 0) {
                this.gtk_widget_get_preferred_size(n7, (GtkRequisition)object);
                if (((GtkRequisition)object).width > 0) {
                    gdkRectangle.x = n3 - ((GtkRequisition)object).width;
                }
            }
        }
        gdkRectangle.width = n5;
        gdkRectangle.height = n6;
        n8 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(n8, n12);
        n7 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(n7, n12);
        OS.gdk_region_offset(n7, n9, n10);
        object = new GdkRectangle();
        OS.gdk_region_get_clipbox(n8, (GdkRectangle)object);
        if (((GdkRectangle)object).width != 0 && ((GdkRectangle)object).height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(n3, n4, n5, n6, false, false, false);
            this.redrawWidget(n, n2, n5, n6, false, false, false);
        } else {
            Object object2;
            int n13;
            if (OS.GTK3) {
                n13 = OS.gdk_cairo_create(n11);
                if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
                    OS.gdk_cairo_set_source_window(n13, n11, 0, 0);
                } else {
                    Cairo.cairo_push_group(n13);
                    OS.gdk_cairo_set_source_window(n13, n11, 0, 0);
                    Cairo.cairo_paint(n13);
                    Cairo.cairo_pop_group_to_source(n13);
                }
                object2 = new double[]{1.0, 0.0, 0.0, 1.0, -n9, -n10};
                Cairo.cairo_pattern_set_matrix(Cairo.cairo_get_source(n13), (double[])object2);
                Cairo.cairo_rectangle(n13, ((GdkRectangle)object).x + n9, ((GdkRectangle)object).y + n10, ((GdkRectangle)object).width, ((GdkRectangle)object).height);
                Cairo.cairo_clip(n13);
                Cairo.cairo_paint(n13);
                Cairo.cairo_destroy(n13);
            } else {
                n13 = OS.gdk_gc_new(n11);
                OS.gdk_gc_set_exposures(n13, true);
                OS.gdk_draw_drawable(n11, n13, n11, ((GdkRectangle)object).x, ((GdkRectangle)object).y, ((GdkRectangle)object).x + n9, ((GdkRectangle)object).y + n10, ((GdkRectangle)object).width, ((GdkRectangle)object).height);
                OS.g_object_unref(n13);
            }
            int n14 = n13 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2 ? 1 : 0;
            if (n13 != 0) {
                object2 = new GdkRectangle();
                ((GdkRectangle)object2).x = n3;
                ((GdkRectangle)object2).y = n4;
                ((GdkRectangle)object2).width = n5;
                ((GdkRectangle)object2).height = n6;
                OS.gdk_region_union_with_rect(n7, (GdkRectangle)object2);
            } else {
                int n15;
                object2 = new GdkRectangle();
                if (n9 != 0) {
                    n15 = n - n9;
                    if (n9 < 0) {
                        n15 = n + n5;
                    }
                    ((GdkRectangle)object2).x = n15;
                    ((GdkRectangle)object2).y = n4;
                    ((GdkRectangle)object2).width = Math.abs(n9);
                    ((GdkRectangle)object2).height = n6;
                    OS.gdk_region_union_with_rect(n7, (GdkRectangle)object2);
                }
                if (n10 != 0) {
                    n15 = n2 - n10;
                    if (n10 < 0) {
                        n15 = n2 + n6;
                    }
                    ((GdkRectangle)object2).x = n3;
                    ((GdkRectangle)object2).y = n15;
                    ((GdkRectangle)object2).width = n5;
                    ((GdkRectangle)object2).height = Math.abs(n10);
                    OS.gdk_region_union_with_rect(n7, (GdkRectangle)object2);
                }
            }
            OS.gdk_window_invalidate_region(n11, n7, bl);
        }
        OS.gdk_region_destroy(n12);
        OS.gdk_region_destroy(n8);
        OS.gdk_region_destroy(n7);
        if (bl) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control2 = controlArray[i];
                Rectangle rectangle = control2.getBoundsInPixels();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) < Math.max(n3, rectangle.x) || Math.min(n4 + n6, rectangle.y + rectangle.height) < Math.max(n4, rectangle.y)) continue;
                control2.setLocationInPixels(rectangle.x + n9, rectangle.y + n10);
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            this.redraw(false);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            this.caret.setFocus();
        }
        return n5;
    }

    @Override
    void setForegroundColor(int n, GdkRGBA gdkRGBA) {
        if (this.cssBackground == null) {
            GdkRGBA gdkRGBA2 = this.display.toGdkRGBA(this.display.COLOR_WIDGET_BACKGROUND);
            this.cssBackground = "SwtFixed {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
        }
        super.setForegroundColor(n, gdkRGBA);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    void updateCaret() {
        int n = this.imHandle();
        if (n == 0) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = this.caret.x;
        gdkRectangle.y = this.caret.y;
        gdkRectangle.width = this.caret.width;
        gdkRectangle.height = this.caret.height;
        OS.gtk_im_context_set_cursor_location(n, gdkRectangle);
    }
}

