<?php
/*
*    Weasy Version 1
*/


function backup (){

 global $SETTING, $WEBSITE, $LANG;

$LANG['create_backup']           = 'バックアップの作成';
$LANG['create_backup_button']    = 'バックアップを作成する';
$LANG['create_backup_attention'] = 'バックアップの対象はページとテンプレートです。';
$LANG['restore_backup']          = 'バックアップの復元';
$LANG['ctime']                   = '作成時刻';
$LANG['comment']                 = 'コメント';
$LANG['complete_create_backup']  = 'バックアップを作成しました。';
$LANG['failed_to_create_backup'] = 'バックアップを作成できませんでした。';
$LANG['complete_restore_backup']  = 'バックアップを復元しました。';
$LANG['failed_to_restore_backup'] = 'バックアップを復元できませんでした。';
$LANG['complete_delete_backup']  = 'バックアップを削除しました。';
$LANG['failed_to_delete_backup'] = 'バックアップを削除できませんでした。';
$LANG['q_accept_restore']        = '本当に復元しますか？';
$LANG['restore']                 = '復元';
$LANG['accept_restore']          = '復元する';




 /*
  *  バックアップの作成、削除
  *
  */
  if(isset($_POST['mode'])){

    if(isset($_POST['do1']))
      $do = $_POST['do1'];
    elseif(isset($_POST['do2']))
      $do = $_POST['do2'];
    elseif(isset($_POST['do3']))
      $do = $_POST['do3'];

    switch($do){

     case 'create':

      $backup = new ZipArchive;
      $backup->open(BACKUP_DIR.'/b_'.time().'.zip', ZipArchive::CREATE);
      $backup->setArchiveComment(time().','.$_POST['comment']);


      //ディレクトリの中を探して、ファイルとディレクトリと追加する関数
      function addDir ($backup, $dir){

        $backup->addEmptyDir($dir);

        foreach(scandir($dir) as $file){

          if(($file == '.') || ($file == '..'))
            continue;

          if(is_dir($dir."/$file"))
            addDir($backup, $dir."/$file");
          else
            $backup->addFile($dir."/$file", $dir."/$file");
        }
      }


      foreach($SETTING['backup_targets'] as $target){
        addDir($backup, $target);
      }

      if($backup->close())
        result(true,  $LANG['complete_create_backup']);
      else
        result(false, $LANG['failed_to_create_backup']);


     break;
     /* ----------------------------------------------------- */

     case 'restore':

      for($i=0; $i < BACKUPS_MAX; $i++)
        if(isset($_POST["r{$i}"]))
          $p = $_POST["r{$i}"];

      $backup = new ZipArchive;
      $backup->open(BACKUP_DIR."/b_{$p}.zip");

      if($backup->extractTo('.'))
        result(true,  $LANG['complete_restore_backup']);
      else
        result(false, $LANG['failed_to_restore_backup']);

      $backup->close();
     break;
     /* ----------------------------------------------------- */

     case 'delete':

      for($i=0; $i < BACKUPS_MAX; $i++)
        if(isset($_POST["r{$i}"]))
          $p = $_POST["r{$i}"];

      if(unlink(BACKUP_DIR."/b_{$p}.zip"))
        result(true,  $LANG['complete_delete_backup'].$LANG['click_refresh_button']);
      else
        result(false, $LANG['failed_to_delete_backup']);

     break;
     /* ----------------------------------------------------- */
    }

    exit();
  }




 /*
  *  バックアップの作成、管理画面
  *
  */


  print <<< HDOC
  <div class="block">
    <h2>{$LANG['create_backup']}</h2>

    <div style="float:left;">
      <span id="resultBox">{$LANG['create_backup_attention']}</span><br><br>
      <p>{$LANG['comment']}&nbsp;<input type="text" name="comment" size="35"></p>
    </div>
    <button onClick="simpleSend('loadingImg', 'admin.php', 'resultBox', Array('mode', 'do1', 'comment'))" style="float:right;"><img src="loading.gif" id="loadingImg" style="display:none;">{$LANG['create_backup_button']}</button>

    <br style="clear:both;">
  </div>

  <div class="block">
    <h2>{$LANG['restore_backup']}</h2>

    <button style="font-weight:bold;float:right;margin:17px;" onClick="location.reload()">{$LANG['refresh']}</button>

    <input type="hidden" name="mode" value="backup">
    <input type="hidden" name="do1"  value="create">
    <input type="hidden" name="do2"  value="restore">
    <input type="hidden" name="do3"  value="delete">

    <table class="pgmngPageList">
     <thead>
     <tr>
        <td style="width:25%">{$LANG['ctime']}</td>
        <td style="width:50%">{$LANG['comment']}</td>
        <td style="width:15%;background-color:#ddd;"></td>
    </tr>
    </thead>
    <tbody>
HDOC;


 $i=0;

  //バックアップを一覧にする
  foreach(glob(BACKUP_DIR.'/b_*.zip') as $file){

    $backup = new ZipArchive;
    $backup->open($file);
    $backupComment = str_getcsv($backup->getArchiveComment());
    $ctime    = date($SETTING['date_format'], $backupComment[0]);
    $comment  = $backupComment[1];
    $backup->close();

    preg_match('/.*\/b\_([0-9]*)\.zip/', $file, $p);
   $p = $p[1];


    print <<< HDOC
      <input type="hidden" name="r$i" value="{$p}">

      <tr class="pgmngPageEntry">
        <td>{$ctime}</td>
        <td>{$comment}</td>
        <td>
          <button class="pgmngButton" onClick="document.getElementById('restoreArea$i').style.display='block';">{$LANG['restore']}</button>
          <button class="pgmngButton" onClick="document.getElementById('deleteArea$i').style.display ='block';">{$LANG['delete']}</button>

          <div id="restoreArea$i" style="display:none;background-color:#999;padding:4px;margin:3px;">
           <p class="small">{$LANG['q_accept_restore']}</p>
            <button class="pgmngButton" onClick="document.getElementById('restoreArea$i').style.display='none';">{$LANG['cancel']}</button>
            <button class="pgmngButton" onClick="simpleSend('', 'admin.php', 'restoreArea$i', Array('r{$i}', 'mode', 'do2'))">{$LANG['accept_restore']}</button>
          </div>

          <div id="deleteArea$i" style="display:none;background-color:#999;padding:4px;margin:3px;">
           <p class="small">{$LANG['q_accept_delete']}</p>
            <button class="pgmngButton" onClick="document.getElementById('deleteArea$i').style.display='none';">{$LANG['cancel']}</button>
            <button class="pgmngButton" onClick="simpleSend('', 'admin.php', 'deleteArea$i', Array('r{$i}', 'mode', 'do3'))">{$LANG['accept_delete']}</button>
          </div>
        </td>
        </tr>
HDOC;

    $i++;
  } // foreach


  print <<< HDOC
</tbody>
<tfoot></tfoot>
</table>
</div>
HDOC;


  return;

}

