<?php
/*
*    Weasy Version 1
*/

chdir('..');

//設定ファイルの読み込み
require_once 'settings.php';
require_once 'lang.php';
require_once ADMIN_DIR. '/weasy.php';


//adminディレクトリ内の*.phpを読み込む
foreach(glob(ADMIN_DIR.'/*.php') as $file){

  if($file != ADMIN_DIR.'/admin.php')
    require_once $file;
}


//ログインしているか確認
if(!auth()){

  $returnURL = (isset($_GET['return_url']))? $_GET['return_url']: 'index.php?mode=dashboard';

  print <<< HDOC

<!DOCTYPE html>
<html>
<head>

<meta charset="utf-8">

<title>{$LANG['login']} | {$WEBSITE['title']}</title>

<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta name="ROBOTS" content="NOINDEX, NOFOLLOW">

<script type="text/javascript" src="script.js">
</script>
<link rel="stylesheet" type="text/css" href="style.css">

</head>
<body>

<div id="white">

<div id="main">
<h1>${LANG['login']}</h1>


 <div style="width:60%;margin-right:auto;margin-left:auto;">

  <script>var dataid = new Array('return_url', 'password', 'mode'); </script>

  <p>{$LANG['password']}&nbsp;
  <input type="password" name="password" size="25">
  <input type="hidden" name="return_url" value="{$returnURL}">
  <input type="hidden" name="mode"       value="login">

  <button onClick="simpleSend('loadingImg', 'login.php', 'resultBox', dataid)">
  <img src="loading.gif" id="loadingImg" style="display:none;">{$LANG['submit']}</button>
  </p>
  <p id="resultBox"></p>

 </div>

</div>
</div>
</body>
</html>
HDOC;

  exit();
}


//ログアウト
if($_GET['mode'] == 'logout'){

  logout();

  print <<< HDOC
<!DOCTYPE html>
<html>
<head>

<meta charset="utf-8">

<title>${LANG['logout']}</title>

<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta name="ROBOTS" content="NOINDEX, NOFOLLOW">

<script type="text/javascript" src="script.js">
</script>
<link rel="stylesheet" type="text/css" href="style.css">

</head>
<body>

<div id="white">

<div id="main">
<h1>{$LANG['logout']}</h1>

{$LANG['complete_logout']}
<a href="{$SETTING['url']}">{$LANG['retrun_to_toppage']}</a>
</div>
</div>
</body>
</html>
HDOC;

  exit();

}


//リクエストを確認
switch(@$_GET['mode']){
  case 'dashboard': $msgModeTitle = $LANG['dashboard'];       $func='dashboard'; break;
  case 'new':       $msgModeTitle = $LANG['create_new_page']; $func='newpage';   break;
  case 'pgmng':     $msgModeTitle = $LANG['pgmng'];           $func='pgmng';     break;
  case 'filemng':   $msgModeTitle = $LANG['filemng'];         $func='filemng';   break;
  case 'edit':      $msgModeTitle = $LANG['edit'];            $func='edit';      break;
  case 'settings':  $msgModeTitle = $LANG['settings'];        $func='settings';  break;
  case 'backup':    $msgModeTitle = $LANG['backup'];          $func='backup';    break;
  case 'template':  $msgModeTitle = $LANG['template'];        $func='template';  break;

  default:         $msgModeTitle = $LANG['dashboard']; $func='dashboard'; break;
}


  switch($WEASY['type']){
   case 'dev':     $type = $LANG['type_dev'];    break;
   case 'stable':  $type = $LANG['type_stable']; break;
  }


print <<< HDOC
<!DOCTYPE html>
<html>
<head>

<meta charset="utf-8">

<title>{$msgModeTitle} | {$WEBSITE['title']}</title>

<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta name="ROBOTS" content="NOINDEX, NOFOLLOW">

<script type="text/javascript" src="script.js">
</script>
<link rel="stylesheet" type="text/css" href="style.css">

</head>
<body>

<div id="white">

<div id="main">

<h1>{$msgModeTitle}</h1>

<div class="navi" onClick="location.href='?mode=dashboard'">
  <p>{$LANG['dashboard']}</p>
</div>

<div class="navi" onClick="openNaviChild('naviChild2');">
  <p>{$LANG['page']}</p>
 <div class="naviChild" id="naviChild2">
  <p onClick="location.href='?mode=new'">  {$LANG['create_new_page']}</p>
  <p onClick="location.href='?mode=pgmng'">{$LANG['pgmng']}</p>
 </div>
</div>

<div class="navi" onClick="location.href='?mode=filemng'">
  <p>{$LANG['file']}</p>
</div>

<div class="navi" onClick="location.href='?mode=template'">
  <p>{$LANG['template']}</p>
</div>

<div class="navi" onClick="openNaviChild('naviChild3');">
  <p>{$LANG['settings_and_others']}</p>
 <div class="naviChild" id="naviChild3">
  <p onClick="location.href='?mode=settings&do=basic'">{$LANG['basic_settings']}</p>
  <p onClick="location.href='?mode=settings&do=change_password'">{$LANG['change_password']}</p>
  <p onClick="location.href='?mode=backup'">  {$LANG['backup']}</p>
  <p onClick="location.href='{$SETTING['help_url']}'">  {$LANG['help']}</p>
  <p onClick="location.href='?mode=logout'">  {$LANG['logout']}</p>
 </div>
</div>

<br style="clear:both;margin-bottom:3em;">
<div id="main2">
HDOC;

$func();

print <<< HDOC
</div>
<footer>
<hr>
<p>Weasy&nbsp;{$LANG['version']}&nbsp;{$WEASY['version']}&nbsp;{$type}</p>
<hr>
</footer>
</div>
</div>
</body>
</html>
HDOC;

exit(0);


