# -*- coding: utf-8 -*-
from wmcommon import *
import httpsproxy_urllib2
from httpsproxy_urllib2 import urllib2
import urllib , cookielib

class WebMonitorHTTPWrapper:
    """
    (customed) urllib2 wrapper.

    """
    def __init__(self,headers=None,proxies=None):
        """
        
        headers : [(header,value),...] ex> [('User-agent', 'Mozilla/5.0), ('Accept-Charset','utf-8;')]
        proxies : {protocol : url,...} ex> {'http': 'http://localhost:20080', 'https': 'https://localhost:20080'}
        debug   : With debug message.
        """
        self.proxies = proxies
        self.headers = headers

    def reset(self):
        """

        Reset client object.
        - Delete session cookies
        """
        self.cj = cookielib.CookieJar()
        handlers = []
        handlers.append(urllib2.HTTPCookieProcessor(self.cj))
        if self.proxies != None:
            handlers.append(urllib2.ProxyHandler(self.proxies))
        self.opener = urllib2.build_opener(*handlers)
        if get_debuglv() > 9:
            for handler in self.opener.handlers:
                if isinstance(handler,urllib2.HTTPHandler):
                    handler.set_http_debuglevel(10)
                elif isinstance(handler,urllib2.HTTPSHandler):
                    handler.set_http_debuglevel(10)
        if self.headers != None:
            self.opener.addheaders = self.headers
        

    def request(self,req):
        """

        Do http(s) request.
        req : urlib2.Request instance.
        """
        debug_out(1,'request => ' + req.get_full_url())
        try:
            r   = self.opener.open(req)
        except IOError,(err):
            raise WebMonitorError('WebMonitorHTTPWrapper::request() => IOError : ' + to_unicode(err) )
        except IOError,(errno,strerror):
            raise WebMonitorError('WebMonitorHTTPWrapper::request() => IOError : ' + strerror.read() )
        except IOError:
            raise WebMonitorError('WebMonitorHTTPWrapper::request() => IOError : ' + strerror.read() )
        except:
            raise WebMonitorError('WebMonitorHTTPWrapper::request() => UnknownError : Maybe shutdown connection !')
        else:
            return (r.read(),r.info())

class WebMonitorForm:
    """
    Request form data bean.

    """
    def __init__(self,url,charset='utf-8',method='GET'):
        """

        url     : Target url
        charset : Parameter charset
        """
        self.url    = url
        self.parms  = {}
        self.charset= charset
        self.method = method

    def set_url(self,url):
        """

        url : Target url
        """
        self.url    = url

    def set_parms(self,parms):
        self.parms = parms
        
    def set_method_post(self):
        """

        Method
        """
        self.method = 'POST'

    def set_method_get(self):
        """

        Method
        """
        self.method = 'GET'

    def gen_request(self):
        """

        Generate urllib2.Request instance.
        """
        parms = {}
        for p,v in self.parms.iteritems():
            p = to_string(p,self.charset)
            v = to_string(v,self.charset)
            parms[p] = v
        data=urllib.urlencode(parms)
        match = re.compile('^([^#]+)').search(self.url)
        url = match.group(1)
        if self.method == 'POST':
            req = urllib2.Request(url)
            req.add_data(data)
            debug_out(3,'gen_request => ' + self.method + ' ' + self.charset + ' ' + self.url + ' -> ' + data )
        else:
            if data != '':
                url = url + '?' + data
            req = urllib2.Request(url)
            debug_out(3,'gen_request => ' + self.method + ' ' + self.charset + ' ' + url )
        return req

def dump_form(form):
    """

    Debug dump
    form : WebMonitorForm instance
    """
    print ''
    print form.method + ' => ' + form.charset + ' ' + form.url
    for p,v in form.parms.iteritems():
        if v == None:
            v = 'None'
        print p + ' => ' + v
