<?php
require_once("./common.php");// 設定・共通ファイル読み込み

// 楽天リクエストURL組み立て
$num = $_GET["num"];// GETでURLにつけられたパラメータ「num」の値を取り出し$numに格納

$rwsurl = "http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=HotelDetailSearch&version=2009-03-26&hotelNo=$num";

// xmlファイルを一度ファイルとして取得して変数に格納
$xml = file_get_contents($rwsurl);

// 楽天の場合「:」が入っている要素名がある。
// simpleXMLでは扱えないので、その文字を削除する。
$xml = str_replace('header:Header', 'headerHeader', $xml);
$xml = str_replace('hotelDetailSearch:HotelDetailSearch', 'hotelDetailSearchHotelDetailSearch', $xml);
// 変数に入れられた文字列をsimpleXMLで読みこむ
$xml = simplexml_load_string($xml);
$item = $xml->Body->hotelDetailSearchHotelDetailSearch;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="&copy; 2009 ムジログ." />
<meta name="Keywords" content="箱根湯本温泉,強羅温泉,仙石原温泉,芦ノ湖温泉,湯河原温泉,旅館,ホテル" />
<meta name="description" content="何度も行きたい箱根温泉の特集です  ～ 箱根湯本温泉、強羅温泉、仙石原温泉、芦ノ湖温泉、湯河原温泉 ～" />
<title><?php echo h($item->hotelName); ?> | 何度も行きたい箱根温泉</title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<div id="wrapper">


<div id="header">
<a href="index.php"><img src="c_img/logo.jpg" alt="何度も行きたい箱根温泉" width="758" height="120" /></a>
</div>

<div id="navigation">
<ol>
<li id="yumoto"><a href="hakoneyumoto.php" accesskey="1">箱根湯本温泉</a></li>
<li id="goura"><a href="goura.php" accesskey="2">強羅温泉</a></li>
<li id="sengokuhara"><a href="sengokuhara.php" accesskey="3">仙石原温泉</a></li>
<li id="ashinoko"><a href="ashinoko.php" accesskey="4">芦ノ湖温泉</a></li>
<li id="yugawara"><a href="yugawara.php" accesskey="5">湯河原温泉</a></li>
<li id="kensaku"><a href="shukuhakuyoyaku.php" accesskey="6">宿泊空室検索</a></li>
</ol>
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai"><?php echo h($item->hotelName); ?></span></div>

<div id="content">

<h2><?php echo h($item->hotelName); ?></h2>
<p><?php echo h($item->hotelSpecial); ?><br />
<a href="<?php echo h($item->hotelAffiliateUrl); ?>" target="_blank">詳細・予約はこちら</a>
</p>

<div class="pic">&nbsp;</div>

<h3>ホテル外観</h3>
<img src="<?php echo h($item->hotelImageUrl); ?>" />

<div class="pic">&nbsp;</div>

<h3>部屋のイメージ</h3>
<img src="<?php echo h($item->roomImageUrl); ?>" />
<?php echo h($item->roomFixture); ?>
<div class="pic">&nbsp;</div>

<h3>地図</h3>
<img src="<?php echo h($item->hotelMapImageUrl); ?>" />
<br clear="all" />
■アクセス：<?php echo h($item->access); ?><br />
■住所：<?php echo h($item->postalCode).h($item->address1).h($item->address2); ?><br />
■宿泊予約センター電話番号（楽天価格用）：<?php echo h($item->reserveTelephoneNo); ?>

<div class="pic">&nbsp;</div>

<h3>&nbsp;</h3>
</div>
<ul id="menu">
<li id="selected"><?php echo h($item->hotelName); ?></li>
</ul>

<div class="ad">
<!-- 160*600 adwords -->
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai"><?php echo h($item->hotelName); ?></span></div>

<div id="footer">
<hr />
<div id="footerl">
Copyright 2009 オトコ磨きドットジェイピー All Rights Reserved.　<a href="http://musilog.net/contact" target="_blank">お問い合わせ（ムジログ）</a><br />
<!-- Rakuten Web Services Attribution Snippet FROM HERE -->
<a href="http://webservice.rakuten.co.jp/" target="_blank"><img src="http://webservice.rakuten.co.jp/img/credit/200709/credit_22121.gif" border="0" alt="楽天ウェブサービスセンター" title="楽天ウェブサービスセンター" width="221" height="21"/></a>
<!-- Rakuten Web Services Attribution Snippet TO HERE -->
</div>

</div>


</div>

<script type="text/javascript">
var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
</script>
<script type="text/javascript">
try {
var pageTracker = _gat._getTracker("UA-148922-12");
pageTracker._trackPageview();
} catch(err) {}</script></body>
</html>
