<?php
require_once("./common.php");// 設定・共通ファイル読み込み
require_once("./common2.php");// サイト設定情報読み込み
$areaname = "芦ノ湖温泉";


// 楽天リクエストURL組み立て
$rwsquery = $areaname;// 楽天検索用クエリー
$rwsquery4url = rawurlencode($rwsquery);// URLエンコード

$rwsurl = "http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&&operation=KeywordHotelSearch&version=2009-02-03&hits=30&sumDisplayFlag=1&keyword=$rwsquery4url";

// xmlファイルを一度ファイルとして取得して変数に格納
$xml = file_get_contents($rwsurl);

// 楽天の場合「:」が入っている要素名がある。
// simpleXMLでは扱えないので、その文字を削除する。
$xml = str_replace('header:Header', 'headerHeader', $xml);
$xml = str_replace('keywordHotelSearch:KeywordHotelSearch', 'keywordHotelSearchKeywordHotelSearch', $xml);
// 変数に入れられた文字列をsimpleXMLで読みこむ
$xml = simplexml_load_string($xml);
$hits = $xml->Body->keywordHotelSearchKeywordHotelSearch->hotelSimple;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="<?php echo h($copyright); ?>" />
<!--<meta name="Keywords" content="箱根湯本温泉,強羅温泉,仙石原温泉,芦ノ湖温泉,湯河原温泉,旅館,ホテル" />
<meta name="description" content="何度も行きたい箱根温泉の特集です  ～ 箱根湯本温泉、強羅温泉、仙石原温泉、芦ノ湖温泉、湯河原温泉 ～" />-->
<title><?php echo h($areaname); ?> | <?php echo h($title); ?></title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<div id="wrapper">


<div id="header">
<h1><a href="index.php"><?php echo h($title); ?></a></h1>
<div class="sutitle"><?php echo h($subtitle); ?></div>
</div>

<div id="navigation">
<ol>
<?php echo $menu; ?>
</ol>
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai"><?php echo h($areaname); ?></span></div>

<div id="content">

<h2><?php echo h($areaname); ?></h2>
<p><?php echo h($areaname); ?>の説明</p>


<?php
foreach ($hits as $hit) {
?>
<h3><?php echo h($hit->hotelName); ?></h3>
<?php echo h($hit->hotelSpecialSum); ?><br />
評価：<?php echo h($hit->reviewAverage); ?><br />
投稿件数：<?php echo h($hit->	reviewCount); ?><br />
<a href="syosai.php?num=<?php echo h($hit->hotelNo); ?>">詳細はこちら</a>

<div class="pic">&nbsp;</div>
<?php
}
?>
<h3>&nbsp;</h3>
</div>
<ul id="menu">
<li id="selected"><?php echo h($areaname); ?></li>
</ul>

<div class="ad">
<!-- 160*600 adwords -->
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai"><?php echo h($areaname); ?></span></div>

<div id="footer">
<hr />
<div id="footerl">
<?php echo h($copyright); ?><br />
<!-- Rakuten Web Services Attribution Snippet FROM HERE -->
<a href="http://webservice.rakuten.co.jp/" target="_blank"><img src="http://webservice.rakuten.co.jp/img/credit/200709/credit_22121.gif" border="0" alt="楽天ウェブサービスセンター" title="楽天ウェブサービスセンター" width="221" height="21"/></a>
<!-- Rakuten Web Services Attribution Snippet TO HERE -->
</div>


</div>


</div>

</body>
</html>
