<?php
require_once("./common.php");// 設定・共通ファイル読み込み
require_once("./common2.php");// サイト設定情報読み込み

// 楽天リクエストURL組み立て
$num = $_GET["num"];// GETでURLにつけられたパラメータ「num」の値を取り出し$numに格納

$rwsurl = "http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=HotelDetailSearch&version=2009-03-26&hotelNo=$num";

// xmlファイルを一度ファイルとして取得して変数に格納
$xml = file_get_contents($rwsurl);

// 楽天の場合「:」が入っている要素名がある。
// simpleXMLでは扱えないので、その文字を削除する。
$xml = str_replace('header:Header', 'headerHeader', $xml);
$xml = str_replace('hotelDetailSearch:HotelDetailSearch', 'hotelDetailSearchHotelDetailSearch', $xml);
// 変数に入れられた文字列をsimpleXMLで読みこむ
$xml = simplexml_load_string($xml);
$hit = $xml->Body->hotelDetailSearchHotelDetailSearch; // 複数情報でなくひとつの宿泊施設の情報のみ取り出す
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="<?php echo h($copyright); ?>" />
<!--<meta name="Keywords" content="箱根湯本温泉,強羅温泉,仙石原温泉,芦ノ湖温泉,湯河原温泉,旅館,ホテル" />
<meta name="description" content="何度も行きたい箱根温泉の特集です  ～ 箱根湯本温泉、強羅温泉、仙石原温泉、芦ノ湖温泉、湯河原温泉 ～" />-->
<title><?php echo h($title); ?><?php echo h($subtitle); ?></title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<div id="wrapper">


<div id="header">
<h1><a href="index.php"><?php echo h($title); ?></a></h1>
<div class="sutitle"><?php echo h($subtitle); ?></div>
</div>

<div id="navigation">
<ol>
<?php echo $menu; ?>
</ol>
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai"><?php echo h($hit->hotelName); ?></span></div>

<div id="content">

<h2><?php echo h($hit->hotelName); ?></h2>
<p><?php echo h($hit->hotelSpecial); ?><br />
<a href="<?php echo h($hit->hotelAffiliateUrl); ?>" target="_blank">詳細・予約はこちら</a>
</p>

<div class="pic">&nbsp;</div>

<h3>ホテル外観</h3>
<img src="<?php echo h($hit->hotelImageUrl); ?>" />

<div class="pic">&nbsp;</div>

<h3>部屋のイメージ</h3>
<img src="<?php echo h($hit->roomImageUrl); ?>" />
<?php echo h($hit->roomFixture); ?>
<div class="pic">&nbsp;</div>

<h3>地図</h3>
<img src="<?php echo h($hit->hotelMapImageUrl); ?>" />
<br clear="all" />
■アクセス：<?php echo h($hit->access); ?><br />
■住所：<?php echo h($hit->postalCode).h($hit->address1).h($hit->address2); ?><br />
■宿泊予約センター電話番号（楽天価格用）：<?php echo h($hit->reserveTelephoneNo); ?>

<div class="pic">&nbsp;</div>

<h3>&nbsp;</h3>
</div>
<ul id="menu">
<li id="selected"><?php echo h($hit->hotelName); ?></li>
</ul>

<div class="ad">
<!-- 160*600 adwords -->
</div>

<div class="pankuzu">
現在の位置&nbsp;:&nbsp;<a href="index.php">ホーム</a>&nbsp;＞&nbsp;<span class="genzai"><?php echo h($hit->hotelName); ?></span></div>

<div id="footer">
<hr />
<div id="footerl">
<?php echo h($copyright); ?><br />
<!-- Rakuten Web Services Attribution Snippet FROM HERE -->
<a href="http://webservice.rakuten.co.jp/" target="_blank"><img src="http://webservice.rakuten.co.jp/img/credit/200709/credit_22121.gif" border="0" alt="楽天ウェブサービスセンター" title="楽天ウェブサービスセンター" width="221" height="21"/></a>
<!-- Rakuten Web Services Attribution Snippet TO HERE -->
</div>


</div>


</div>

</body>
</html>
