<?php
require_once("./common.php");// 設定・共通ファイル読み込み
require_once 'Cache/Lite.php';//これがサーバーに入っている前提で

// エラー表示止め
//ini_set('error_reporting', E_ALL | E_STRICT);
//ini_set('display_errors', 'off');

// 最低価格と最高価格の設定
$minprice = "100";
$maxprice = "1000000";


$query = $_GET['word'];
$query4url = urlencode($query); // URLエンコード

// 初期設定

// リクエストURL組立。アフィリエイトリンク書き出し




// YAHOO!ショッピングリクエストURL組み立て
$ywsurl = "http://shopping.yahooapis.jp/ShoppingWebService/V1/itemSearch?appid=$appid&query=$query4url&sort=%2Bprice&hits=5&availability=1&price_from=$minprice&price_to=$maxprice";
//$ywsurl = $ywsurl . "&affiliate_type=yid&affiliate_id=$token";
$ywsurl = $ywsurl . "&affiliate_type=vc&affiliate_id=http%3A%2F%2Fck.jp.ap.valuecommerce.com%2Fservlet%2Freferral%3Fsid%3D" . $sid . "%26pid%3D" . $pid . "%26vc_url%3D";

$cacheId = $ywsurl;
$ywsCache = new Cache_Lite($cacheOptions);

if ($cache = $ywsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $ywsBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $ywsBuff = file_get_contents($ywsurl);
    $ywsCache->save($ywsBuff,$cacheId);// キャッシュとして保存
}

//キャッシュ時間取得
$chashjikan = date("Y/m/d H:i:s", $ywsCache->lastModified());

$xml = simplexml_load_string ($ywsBuff);
if ($xml["totalResultsReturned"] != 0) {
	$hits = $xml->Result->Hit;
}
foreach ($hits as $hit) {
$itemname[] = h($hit->Name);
$linkurl[] = h($hit->Url);
$imgurl[] = h($hit->Image->Medium);
$price[] = h($hit->Price);
$description[] = h($hit->Description);
$shopname[] = h($hit->Store->Name);
$souryou[] = h($hit->Shipping->Name);
$reviewnum[] = h($hit->Review->Count);
$reviewavr[] = h($hit->Review->Rate);
$reviewurl[] = h($hit->Review->Url);
}




// 楽天リクエストURL組み立て
$rwsurl = "http://api.rakuten.co.jp/rws/1.13/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=ItemSearch&version=2009-02-03&keyword=$query4url&sort=%2BitemPrice&hits=5&availability=1&minPrice=$minprice&maxPrice=$maxprice";


// 楽天simpleXML,cache,データ取り出し配列変数に代入
$cacheId = $rwsurl;
$rwsCache = new Cache_Lite($cacheOptions);

if ($cache = $rwsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $rwsBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $rwsBuff = file_get_contents($rwsurl);
    $rwsCache->save($rwsBuff,$cacheId);// キャッシュとして保存
}
$rwsBuff = str_replace('header:Header', 'headerHeader', $rwsBuff);
$rwsBuff = str_replace('itemSearch:ItemSearch', 'itemSearchItemSearch', $rwsBuff);

$xml = simplexml_load_string ($rwsBuff);
$hits = $xml->Body->itemSearchItemSearch->Items->Item;

foreach ($hits as $hit) {
$itemname[] = h($hit->itemName);
$linkurl[] = h($hit->affiliateUrl);
if (strlen($hit->mediumImageUrl)) {
	$imgurl[] = h($hit->mediumImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}
$price[] = h($hit->itemPrice);
$description[] = h($hit->itemCaption);
$shopname[] = h($hit->shopName);
//送料フラグ 	postageFlag 	0：送料込
//1：送料別
if ($hit->postageFlag == 0) {
	$souryou[] = "送料無料";
} else {
	$souryou[] = "送料別";
}
$reviewnum[] = h($hit->reviewCount);
$reviewavr[] = h($hit->reviewAverage);
$reviewurl[] = "";
}


// linkshareリクエストURL組み立て
$lsurl = "http://feed.linksynergy.com/productsearch?token=$lstoken&keyword=$query4url&max=5";
// &mid=3472,25051

// リンクシェアXML,cache,データ取り出し配列変数に代入
$cacheId = $lsurl;
$lsCache = new Cache_Lite($cacheOptions);

if ($cache = $lsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $lsBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $lsBuff = file_get_contents($lsurl);
    $lsCache->save($lsBuff,$cacheId);// キャッシュとして保存
}

$xml = simplexml_load_string ($lsBuff);
$hits = $xml->item;

foreach ($hits as $hit) {
if (!is_numeric(mb_strpos($hit->merchantname,"携帯"))) {
$itemname[] = h($hit->productname);
$linkurl[] = h($hit->linkurl);
if (strlen($hit->imageurl)) {
	$imgurl[] = h($hit->imageurl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->price);
$description[] = h($hit->description->short);
$shopname[] = h($hit->merchantname);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
}
}



// バリューコマースリクエストURL組み立て
$vcurl = "http://webservice.valuecommerce.ne.jp/productdb/search?token=$vctoken&keyword=$query4url&sort_by=price&sort_order=asc&price_max=$maxprice&price_min=$minprice&ec_code=02t5n,0png4,0zttq,05f47,0j3hc,08x8b,07s9u,08fsg,bdrxs,0ha4k,0jcf6,03p68,03gpr,0wz95,09muc,bdufh,077ap,02spk,090a7,078nc";

// バリュコマsimpleXML,cache,データ取り出し配列変数に代入
$cacheId = $vcurl;
$vcCache = new Cache_Lite($cacheOptions);

if ($cache = $vcCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $vcBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $vcBuff = file_get_contents($vcurl);
    $vcCache->save($vcBuff,$cacheId);// キャッシュとして保存
}

$vcBuff = str_replace('vc:', 'vc', $vcBuff);
$xml = simplexml_load_string ($vcBuff);
$hits = $xml->channel->item;

foreach ($hits as $hit) {
$itemname[] = h($hit->title);

$linkurl[] = h($hit->link);

// 画像URL取り出し
$img = array();
foreach($hit->vcimage as $vcimg) {
    $img[]=$vcimg["url"];
}

if (strlen($img[1])) {
	$imgurl[] = h($img[1]);
} else {
	if (strlen($img[2])) {
		$imgurl[] = h($img[2]);
	} else {
	$imgurl[] = "c_img/noimage.gif";
	}
}

$price[] = h($hit->vcprice);
$description[] = h($hit->description);

// ストア名とサブストア名が一緒ならサブストア名は使わない（ビッダーズとか）
if (h($hit->vcmerchantName) == h($hit->vcsubStoreName)) {
$shopname[] = h($hit->vcmerchantName);
} else {
$shopname[] = h($hit->vcmerchantName) . h($hit->vcsubStoreName);
}
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
}


// アクセストレードリクエストURL組み立て
// http://interspace.typepad.jp/webservice/atws/index.html
$aturl = "http://xml.accesstrade.net/at/ws.html?ws_type=searchgoods&ws_ver=1&ws_id=$attoken&search=$query4url&price_max=$maxprice&price_min=$minprice&row=5&sort1=3";

// バリュコマsimpleXML,cache,データ取り出し配列変数に代入
$cacheId = $aturl;
$atCache = new Cache_Lite($cacheOptions);

if ($cache = $atCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $atBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $atBuff = file_get_contents($aturl);
    $atCache->save($atBuff,$cacheId);// キャッシュとして保存
}

//キャッシュ時間取得
$chashjikan = date("Y/m/d H:i:s", $atCache->lastModified());

$xml = simplexml_load_string ($atBuff);
$hits = $xml->Goods;

foreach ($hits as $hit) {
$itemname[] = h($hit->GoodsName);

$linkurl[] = h($hit->LinkCode);
$img = array();
// 画像情報取り出し


if (strlen($hit->ImageUrl)) {
	$imgurl[] = h($hit->ImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->Price);
$description[] = h($hit->Explanation);
$shopname[] = h($hit->ShopName);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
}

// AmazonリクエストURL組み立て
// 基本的なリクエストを作成します
// - この部分は今まで通り
$baseurl = 'http://ecs.amazonaws.jp/onca/xml';
$params = array();
$params['Service']        = 'AWSECommerceService';
$params['AWSAccessKeyId'] = $awssubid;
$params['Version']        = '2009-03-31';
$params['Operation']      = 'ItemSearch'; // ← ItemSearch オペレーションの例
$params['SearchIndex']    = 'Blended';
$params['Keywords']       = $query4url;     // ← 文字コードは UTF-8
$params['AssociateTag']   = $awsassid;
$params['Condition']   = 'New';
$params['ContentType']   = 'text/xml';
$params['ResponseGroup']   = 'Medium,Reviews,OfferSummary';

//$awsurl = "http://webservices.amazon.co.jp/onca/xml?AWSAccessKeyId=$awssubid&AssociateTag=$awsassid&Condition=New&ContentType=text/xml&Keywords=$query4url&Operation=ItemSearch&ResponseGroup=Medium,Reviews,OfferSummary&SearchIndex=Blended&Service=AWSECommerceService&Timestamp=" . gmdate('Y-m-d\TH:i:s\Z') . "&Version=2009-01-06";


// Timestamp パラメータを追加します
// - 時間の表記は ISO8601 形式、タイムゾーンは UTC(GMT)
$params['Timestamp'] = gmdate('Y-m-d\TH:i:s\Z');

// パラメータの順序を昇順に並び替えます
ksort($params);

// canonical string を作成します
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);

// 署名を作成します
// - 規定の文字列フォーマットを作成
// - HMAC-SHA256 を計算
// - BASE64 エンコード
$parsed_url = parse_url($baseurl);
$string_to_sign = "GET\n{$parsed_url['host']}\n{$parsed_url['path']}\n{$canonical_string}";
$signature = base64_encode(hash_hmac('sha256', $string_to_sign, $awsseckey, true));

// URL を作成します
// - リクエストの末尾に署名を追加
$awsurl = $baseurl.'?'.$canonical_string.'&Signature='.urlencode_rfc3986($signature);


$cacheId = $awsurl;
$awsCache = new Cache_Lite($cacheOptions);

if ($cache = $awsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $awsBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $awsBuff = file_get_contents($awsurl);
    $awsCache->save($awsBuff,$cacheId);// キャッシュとして保存
}

$xml = simplexml_load_string ($awsBuff);

$hits = $xml->Items->Item;;

foreach ($hits as $hit) {
// amzonのみ値段の処理をここで追加
if ($hit->OfferSummary->LowestNewPrice->Amount > $minprice) {
$itemname[] = h($hit->ItemAttributes->Title);
$linkurl[] = h($hit->DetailPageURL);
$imgurl[] = h($hit->MediumImage->URL);
$price[] = h($hit->OfferSummary->LowestNewPrice->Amount);
$description[] = h($hit->EditorialReviews->EditorialReview->Content);
$shopname[] = "Amazon.co.jp";
$souryou[] = "";
$reviewnum[] = h($hit->CustomerReviews->TotalReviews);
$reviewavr[] = h($hit->CustomerReviews->AverageRating);
$reviewurl[] = "";
}
}


// 値段安い順番に並び替える（全部）
asort($price); 

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="&copy; 2009 横断検索 All Rights Reserved." />
<meta name="Keywords" content="<?php echo rawurldecode($query4url); ?>" />
<meta name="description" content="<?php echo rawurldecode($query4url); ?>の検索結果" />
<title><?php echo rawurldecode($query4url); ?>の検索結果</title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<h2><?php echo rawurldecode($query4url); ?>の検索結果</h2>
<p>検索結果<br />
（更新日時：<?php echo $chashjikan; ?>）</p>
<p>&nbsp;</p>

<p><?php foreach ($price as $key => $value) { ?>

<h3><?php echo $itemname[$key]; ?></h3>
<div class="itempic" style="background: transparent url(<?php echo $imgurl[$key]; ?>) no-repeat scroll center center; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial;"><a href="<?php echo $linkurl[$key]; ?>" target="_blank"><img src="c_img/spacer.gif" class="line-height"/><!--<img src="<?php echo $imgurl[$key]; ?>" class="inner_image" />--></a></div>
税込価格：<span class="price"><?php echo number_format($price[$key]); ?>円</span>　<?php if (strlen($souryou[$key])) {echo "（".$souryou[$key]."）"; }  ?><br />
販売サイト：<?php echo $shopname[$key]; ?><br />
<?php echo mb_substr ($description[$key],0,200,"utf-8"); ?>...<br />
<?php if (strlen($reviewnum[$key])) { ?>
レビュー件数：<?php echo $reviewnum[$key]; ?>件　レビュー平均点：<?php echo $reviewavr[$key]; ?>点<br />
<?php } ?>
<a href="<?php echo $linkurl[$key]; ?>" target="_blank">この商品の詳細をECサイトで確認する</a>

<div class="pic">&nbsp;</div>

<?php } ?>

</p>
<p>
※フッターに各Webサービスの利用規約にしたがいWebサービスを利用している旨を記入すること！
</p>
</body>
</html>
