<?php
require_once("./common.php");// 設定・共通ファイル読み込み
require_once 'Cache/Lite.php';//これがサーバーに入っている前提で

// エラー表示止め
ini_set('error_reporting', E_ALL | E_STRICT);
ini_set('display_errors', 'off');


$query = $_GET['word'];
$query4url = urlencode($query); // URLエンコード
$yoyakuyear = $_GET['year'];
$yoyakumonth = $_GET['month'];
$yoyakudate = $_GET['date'];
$stay_date = $_GET['stay_date'];

//チェックイン年月日
$stt =  strtotime($yoyakuyear.'-'.$yoyakumonth.'-'.$yoyakudate);
$checkinyymmdd = date("Y-m-d", $stt);

//チェックアウト年月日
$baseSec = mktime(0, 0, 0, $yoyakumonth, $yoyakudate, $yoyakuyear);
$addSec = $stay_date * 86400;//宿泊数×１日の秒数
$targetSec = $baseSec + $addSec;
$checkoutyymmdd = date("Y-m-d", $targetSec);

$jalanyadono = $_GET['jalanyadono'];
$rakutenyadono = $_GET['rakutenyadono'];
$room_count = $_GET['room_count'];
$adult = $_GET['adult'];

// 楽天リクエストURL組み立て
$rwsurl = "http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=VacantHotelSearch&version=2008-11-13&hotelNo=$rakutenyadono&checkinDate=$checkinyymmdd&checkoutDate=$checkoutyymmdd&adultNum=$adult&roomNum=$room_count";



// 楽天simpleXML,cache,データ取り出し配列変数に代入
$cacheId = $rwsurl;
$rwsCache = new Cache_Lite($cacheOptions);

if ($cache = $rwsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $rwsBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $rwsBuff = file_get_contents($rwsurl);
    $rwsCache->save($rwsBuff,$cacheId);// キャッシュとして保存
}
$rwsBuff = str_replace('header:Header', 'headerHeader', $rwsBuff);
$rwsBuff = str_replace('vacantHotelSearch:VacantHotelSearch', 'vacantHotelSearchVacantHotelSearch', $rwsBuff);

$xml = simplexml_load_string ($rwsBuff);
$hits = $xml->Body->vacantHotelSearchVacantHotelSearch->room;

foreach ($hits as $hit) {
$itemname[] = h($hit->planName)."＠楽天トラベル";
$linkurl[] = h($hit->reserveAffiliateUrl);
if (strlen($hit->mediumImageUrl)) {
	$imgurl[] = h($hit->mediumImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}
$price[] = h($hit->dailyCharge->rakutenCharge);
$description[] = h($hit->planContents);
$shopname[] = h($hit->roomName);
}




// じゃらんURL組み立て
$jalanindate =  date("Ymd", $stt);
$jalurl = "http://jws.jalan.net/APIAdvance/StockSearch/V1/?key=vir12148808cef&h_id=$jalanyadono&stay_date=$jalanindate&stay_count=$stay_date&room_count=$room_count&adult_num=$adult";


// じゃらんsimpleXML,cache,データ取り出し配列変数に代入
$cacheId = $jalurl;
$jalCache = new Cache_Lite($cacheOptions);

if ($cache = $jalCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $jalBuff = $cache;
}
else{
    // キャッシュがなければデータを取りに行く
    $jalBuff = file_get_contents($jalurl);
    $jalCache->save($jalBuff,$cacheId);// キャッシュとして保存
}

$xml = simplexml_load_string ($jalBuff);
$hits = $xml->Plan;

foreach ($hits as $hit) {
$itemname[] = h($hit->PlanName)."＠じゃらんnet";
$linkurl[] = h($hit->Stay->PlanDetailURL);
if (strlen($hit->mediumImageUrl)) {
	$imgurl[] = h($hit->mediumImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}
$price[] = h($hit->Stay->Date->Rate);
$description[] = h($hit->PlanPictureCaption);
$shopname[] = h($hit->RoomName);
}

// 値段安い順番に並び替える（全部）
asort($price); 

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="&copy; 2009 横断検索 All Rights Reserved." />
<meta name="Keywords" content="チェックイン：<?php echo $checkinyymmdd; ?>、チェックアウト：<?php echo $checkoutyymmdd; ?>、大人<?php echo $adult; ?>人、部屋数<?php echo $room_count; ?>のプラン検索結果" />
<meta name="description" content="チェックイン：<?php echo $checkinyymmdd; ?>、チェックアウト：<?php echo $checkoutyymmdd; ?>、大人<?php echo $adult; ?>人、部屋数<?php echo $room_count; ?>のプラン検索結果" />
<title>チェックイン：<?php echo $checkinyymmdd; ?>、チェックアウト：<?php echo $checkoutyymmdd; ?>、大人<?php echo $adult; ?>人、部屋数<?php echo $room_count; ?>のプラン検索結果</title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<h2>チェックイン：<?php echo $checkinyymmdd; ?>、チェックアウト：<?php echo $checkoutyymmdd; ?>、大人<?php echo $adult; ?>人、部屋数<?php echo $room_count; ?>のプラン検索結果</h2>
<p>検索結果<br />
（更新日時：<?php echo $chashjikan; ?>）</p>
<p>&nbsp;</p>

<p><?php foreach ($price as $key => $value) { ?>

<h3><?php echo $itemname[$key]; ?></h3>

税込価格：<span class="price"><?php echo number_format($price[$key]); ?>円</span><br />
部屋名称：<?php echo $shopname[$key]; ?><br />
<?php echo mb_substr ($description[$key],0,200,"utf-8"); ?>...<br />

<a href="<?php echo $linkurl[$key]; ?>" target="_blank">予約する</a>

<div class="pic">&nbsp;</div>

<?php } ?>

</p>
<p>
※フッターに各Webサービスの利用規約にしたがいWebサービスを利用している旨を記入すること！
</p>
</body>
</html>
