<?php
require_once("./common.php");// 設定・共通ファイル読み込み

// モバイル処理用のライブラリ
require_once 'Mobile_Common.php';

// 開始処理
mobileStart();

/**
 * GPS測位結果を取得する
 *
 * @return 緯度（lat）と経度（lon）の連想配列
 */
function getGpsResult()
{
    $lat = null;
    $lon = null;
    
    switch (whichCarrier()) {
    case CARRIER_DOCOMO:
        if (isset($_POST['LAT']) && isset($_POST['LON'])) {
            // ドコモはPOSTでパラメタ名大文字で送信されてくる
            $lat = $_POST['LAT'];
            $lon = $_POST['LON'];
            $lat = convertDmsToDegree($lat);
            $lon = convertDmsToDegree($lon);
        }
        break;
        
    case CARRIER_EZWEB:
        if (isset($_GET['lat']) && isset($_GET['lon'])) {
            // EZwebはGETでパラメタ名小文字で送信されてくる
            $lat = $_GET['lat'];
            $lon = $_GET['lon'];
            $lat = convertDmsToDegree($lat);
            $lon = convertDmsToDegree($lon);
        }
        break;
        
    case CARRIER_SOFTBANK:
        if (isset($_GET['pos'])) {
            $pos = $_GET['pos'];
            // Softbankは1つのパラメタに緯度経度がくっついて送信されてくるため、正規表現で分離する
            preg_match('!N([0-9\.]+)E([0-9\.]+)!', $pos, $match);
            $lat = $match[1];
            $lon = $match[2];
            $lat = convertDmsToDegree($lat);
            $lon = convertDmsToDegree($lon);
        }
        break;
    }
    if ($lat != null && $lon != null) {
        // 正常に緯度経度が送信されてきた場合は、次の形式の連想配列で返す
        return array('lat' => $lat, 'lon' => $lon);
    } else {
        // 緯度経度の取得に失敗した場合はnullを返す
        return null;
    }
}

// GPS測位結果を取得,degree単位に変換された状態でやってくる
$lat = null;
$lon = null;
$gpsres = getGpsResult();
if ($gpsres != null) {
    $lat = $gpsres['lat'];
    $lon = $gpsres['lon'];
}


$ekilat = $lat;
$ekilng = $lon;

$rwsurl = "http://api.rakuten.co.jp/rws/2.0/rest?developerId=$rwsdevid&&affiliateId=$rwsaffid&operation=SimpleHotelSearch&version=2008-11-13&latitude=$ekilat&longitude=$ekilng&searchRadius=1&datumType=1&carrier=1&hits=5";


// xmlファイルを一度ファイルとして取得して変数に格納
$xml = file_get_contents($rwsurl);

// 楽天の場合「:」が入っている要素名がある。
// simpleXMLでは扱えないので、その文字を削除する。
$xml = str_replace('header:Header', 'headerHeader', $xml);
$xml = str_replace('simpleHotelSearch:SimpleHotelSearch', 'simpleHotelSearchSimpleHotelSearch', $xml);
// 変数に入れられた文字列をsimpleXMLで読みこむ
$xml = simplexml_load_string($xml);
$items = $xml->Body->simpleHotelSearchSimpleHotelSearch->hotel;

$i = 1;
foreach ($items as $item) {
	$marker = $marker.'|'.h($item->latitude).','.h($item->longitude).",blue".$i;
	$i=$i+1;
}

?>
<html>
<head>
<meta http-equiv="Content-Type" content="Application/xhtml+xml; charset=Shift_JIS" />
<title>ホテル検索</title>
</head>
<body>
<img src="http://maps.google.com/staticmap?center=<?php echo $lat; ?>,<?php echo $lon; ?>&markers=<?php echo $lat; ?>,<?php echo $lon; ?>,red<?php echo $marker; ?>&zoom=15&size=240x240&key=<?php echo $google_maps_apikey; ?>&maptype=mobile">

<br/>
<?php
$i=1;
foreach ($items as $item) {
?>
<h3><?php echo $i.'.'.h($item->hotelName); ?></h3>
<?php echo h($item->hotelSpecial); ?><br />
<?php echo h($item->access); ?><br />
<a href="<?php echo h($item->hotelAffiliateUrl); ?>">予約</a>
<!--評価：<?php echo h($item->reviewAverage); ?><br />-->
<!--投稿件数：<?php echo h($item->	reviewCount); ?><br />-->

<div class="pic">&nbsp;</div>
<?php
	$i=$i+1;
}
?>
<br/>

</body>
</html>
<?php

//■終了処理
mobileFinish();

?>
