<?php
require_once("./common.php");// 設定・共通ファイル読み込み
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <title>Google マップ表示テスト</title>
    <script src="http://maps.google.co.jp/maps?hl=ja&amp;file=api&amp;v=2&amp;key=<?php echo $google_maps_apikey; ?>"
            type="text/javascript"></script>
    <script type="text/javascript">
    function initialize() {
      if (GBrowserIsCompatible()) {
      	// <div id="map_canvas">と結びつけて、その領域に地図を描く
        var map = new GMap2(document.getElementById("map_canvas"));
        // 指定した緯度と経度を中心ににして地図のズームレベルは17で描画する。
        var latlng = new GLatLng(35.252909, 139.048462); // 緯度経度を変数に格納
        map.setCenter(latlng, 17); //　緯度経度情報とズームレベルを指定
        // ☆彡拡大縮小のコントローラーを追加する☆彡
        // map.addControl(new GSmallMapControl());
        map.addControl(new GLargeMapControl()); // ズームのつまみ付きバージョン
        // ☆彡地図種類コントロールボタン追加☆彡
        map.addControl(new GMapTypeControl());
        //☆彡スケールコントローラ(尺度定規)を付ける☆彡
		map.addControl(new GScaleControl());
		//☆彡中央にマーカーを表示する☆彡
		var marker = new GMarker(latlng);
		map.addOverlay(marker);
        // ストリートビューが可能な道を表示
        map.addOverlay(new GStreetviewOverlay());
        // ストリートビュー(GStreetviewPanorama)を実際に表示する
		stPanorama = new GStreetviewPanorama(document.getElementById("streetview"),{latlng:latlng,pov:{yaw:140}});
		
	   	 // エラー処理
		GEvent.addListener(stPanorama, "error", onError);
      }
    }
	function onError(errorCode) {
	    if (errorCode == 600) {
	        document.getElementById("streetview").innerHTML = "<p>ストリートビュー未対応エリアです。</p>";
	        return;
	    }
	    else if (errorCode == 603) {
	        document.getElementById("streetview").innerHTML = "<p>ブラウザがFlash未対応です。</p>";
	        return;
	    }
	}
    </script>
  </head>
  <body onload="initialize()" onunload="GUnload()">
  	<!-- 地図はここに描画される -->
    <div id="map_canvas" style="width: 400px; height: 400px;float:left;"></div>
    <div id="streetview" style="width: 400px; height: 400px;float:left;"></div>
  </body>
</html>