/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.connection;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

public class TransactionFilter
implements Filter {
    private AbstractLog log;
    private boolean initFlag = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        BeanFactory factory = BeanFactory.getInstance();
        if (!factory.isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        try {
            this.log = (AbstractLog)factory.getInstance("Log");
            if (!this.log.isInit()) {
                this.log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception ioe) {
            this.log = SimpleLog.getInstance();
            this.log.info(ioe.getMessage());
        }
        try {
            ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
            manager.init();
            this.log.info("completed initialize instance='" + manager.getClass().getName() + "'");
            this.log.info("ConnectionManager Info=" + manager.toString());
            this.initFlag = true;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            block13: {
                try {
                    if (this.initFlag) {
                        TransactionUtil.beginTransaction();
                        chain.doFilter(request, response);
                        if (TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_COMMIT) {
                            TransactionUtil.commitTransaction();
                            this.log.debug("COMMIT TRANSACTION");
                            break block13;
                        }
                        if (TransactionUtil.getTransaction().getTranStatus() == Transaction.PLEASE_ROLLBACK) {
                            TransactionUtil.rollbackTransaction();
                            this.log.debug("ROLLBACK TRANSACTION");
                        }
                        break block13;
                    }
                    this.log.warn("ConnectionManager is not initialized");
                    chain.doFilter(request, response);
                }
                catch (IOException ioe) {
                    TransactionUtil.rollbackTransaction();
                    TransactionUtil.returnTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                    this.log.error(ioe);
                    throw ioe;
                }
                catch (ServletException se) {
                    TransactionUtil.rollbackTransaction();
                    TransactionUtil.returnTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                    this.log.error((Exception)((Object)se));
                    throw se;
                }
                catch (NullPointerException e) {
                    TransactionUtil.rollbackTransaction();
                    TransactionUtil.returnTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                    this.log.error(e);
                    throw new ServletException(e.getMessage());
                }
                catch (RuntimeException re) {
                    TransactionUtil.rollbackTransaction();
                    TransactionUtil.returnTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                    this.log.error(re);
                    re.printStackTrace();
                    throw new ServletException(re.getMessage());
                }
                catch (Exception e) {
                    TransactionUtil.rollbackTransaction();
                    TransactionUtil.returnTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                    this.log.error(e);
                    throw new ServletException(e.getMessage());
                }
                catch (Error e) {
                    TransactionUtil.rollbackTransaction();
                    TransactionUtil.returnTransaction();
                    this.log.debug("ROLLBACK TRANSACTION");
                    this.log.error(e);
                    throw new ServletException(e.getMessage());
                }
            }
            Object var5_12 = null;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            TransactionUtil.returnTransaction();
            throw throwable;
        }
        TransactionUtil.returnTransaction();
    }

    public void destroy() {
        BeanFactory factory = BeanFactory.getInstance();
        ConnectionManager manager = (ConnectionManager)factory.createInstance("ConnectionManager");
        manager.destroy();
    }
}

