/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.AutoNumberDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;

public class BaseDao {
    protected Transaction transaction = TransactionUtil.getTransaction();
    static /* synthetic */ Class class$0;

    public BaseDao() {
        if (this.transaction == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.itscool.commons.dao.BaseDao");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new RuntimeException(String.valueOf(clazz.getName()) + " transaction is null.");
        }
    }

    public void setTransaction(Transaction trn) {
        this.transaction = trn;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void insert(Criteria crt, Object bean) throws TransactionException {
        String sql = crt.toInsertString(bean);
        this.transaction.execute(sql);
    }

    public void update(Criteria crt, Object bean) throws TransactionException {
        String sql = crt.toUpdateString(bean);
        this.transaction.execute(sql);
    }

    public void delete(Criteria crt) throws TransactionException {
        String sql = crt.toDeleteString();
        this.transaction.execute(sql);
    }

    public List select(Criteria crt) throws TransactionException {
        ArrayList<Object> result = new ArrayList<Object>();
        Records list = null;
        list = this.transaction.select(crt.toSelectString());
        RecordMap recordMap = crt.getRecord();
        int i = 0;
        while (i < list.size()) {
            Record record = (Record)list.get(i);
            Object obj = this.createObject(recordMap, record);
            HashMap fkRecordMaps = crt.getFkRecordMaps();
            Set keySet = fkRecordMaps.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String propertyName = (String)it.next();
                RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(propertyName);
                String fkClassName = fkRecordMap.getClassName();
                RecordMap joinRecordMap = RecordMapFactory.createRecordMap(fkClassName);
                Object fkObj = this.createObject(joinRecordMap, record);
                BeanUtil.setProperty(obj, propertyName, fkObj);
            }
            result.add(obj);
            ++i;
        }
        return result;
    }

    private Object createObject(RecordMap recordMap, Record record) throws TransactionException {
        Object obj = BeanUtil.createInstance(recordMap.getClassName());
        Set keySet = recordMap.getFields().keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap field = (FieldMap)recordMap.getFields().get(key);
            Object value = record.get(field.getColumAsName());
            try {
                field.setPropertyValue(obj, value);
            }
            catch (Exception e) {
                System.out.print(String.valueOf(obj.getClass().getName()) + ":");
                System.out.print(field.getPropertyName());
                System.out.println(":" + value);
                e.printStackTrace();
            }
        }
        return obj;
    }

    public int getNewId(String tableName, String pkCulomName) {
        int id = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select MAX(");
        sql.append(tableName).append(".").append(pkCulomName);
        sql.append(") AS NEW_ID FROM ").append(tableName);
        Records result = this.transaction.select(sql.toString());
        if (result.size() > 0) {
            Record record = result.getRecord(0);
            id = record.getInt("NEW_ID");
            ++id;
        }
        return id;
    }

    public int getNewIdFromAutoNumber(String tableName) {
        int id = 0;
        AutoNumberDao dao = new AutoNumberDao();
        id = dao.getNext(tableName);
        return id;
    }
}

