/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.tagex;

import java.util.Calendar;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.weber.tagex.DateElement;
import org.itscool.weber.tagex.MonthTable;

public class MonthTableMain {
    public static void toDisplay(MonthTable month) {
        StringBuffer sb = new StringBuffer();
        DateElement day = month.getDay(month.getYear(), month.getMonth(), 1);
        String sp = "|";
        String line = System.getProperty("line.separator");
        sb.append(month.getYear()).append("/");
        sb.append(month.getMonth()).append(line);
        sb.append("---+---+---+---+---+---+---+");
        sb.append(line);
        sb.append("sun|mon|tue|wen|thr|fri|sat|");
        sb.append(line);
        sb.append("---+---+---+---+---+---+---+");
        sb.append(line);
        int firstYobi = day.getYobi();
        if (firstYobi != 1) {
            Calendar cal = DateFormatUtil.getLastMonthWeek((int)month.getYear(), (int)month.getMonth());
            int i = 1;
            while (i < firstYobi) {
                day = month.getDay(cal);
                if (day.getDay() < 10) {
                    sb.append(" ");
                }
                sb.append(day.getDay());
                sb.append("-").append(sp);
                ++i;
                cal.add(5, 1);
            }
        }
        int i = 0;
        while (i < month.getMaxday()) {
            day = month.getDay(month.getYear(), month.getMonth(), i + 1);
            if (day.getDay() < 10) {
                sb.append(" ");
            }
            sb.append(day.getDay());
            if (day.isHoliday()) {
                sb.append("*").append(sp);
            } else {
                sb.append(" ").append(sp);
            }
            if (day.getYobi() == 7) {
                sb.append(line);
            }
            ++i;
        }
        DateElement lastDay = month.getDay(month.getYear(), month.getMonth(), month.getMaxday());
        if (lastDay.getYobi() != 7) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, month.getYear());
            cal.set(2, month.getMonth() - 1);
            cal.set(5, month.getMaxday());
            int i2 = lastDay.getYobi();
            while (i2 < 7) {
                day = month.getDay(cal);
                if (day.getDay() < 10) {
                    sb.append(" ");
                }
                sb.append(day.getDay());
                sb.append("+").append(sp);
                ++i2;
                cal.add(5, 1);
            }
            sb.append(line);
        }
        sb.append("---+---+---+---+---+---+---+");
        sb.append(line);
        System.out.println(sb.toString());
    }

    public static void main(String[] argv) {
        int i = 0;
        while (i < 12) {
            MonthTable month = new MonthTable(2005, i + 1);
            MonthTableMain.toDisplay(month);
            ++i;
        }
    }
}

