/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.testcase;

import java.net.URL;
import java.util.LinkedList;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.action.Action;
import org.itscool.weber.testcase.DbTestConfigReader;
import org.itscool.weber.testcase.FieldData;
import org.itscool.weber.testcase.RecordData;
import org.itscool.weber.testcase.TableData;
import org.itscool.weber.testcase.WeberTestCase;
import org.itscool.weber.user.User;

public abstract class WeberDbTestCase
extends WeberTestCase {
    protected ConnectionManager mgr;
    protected static LinkedList testDataList = new LinkedList();
    private static boolean initFlg = false;

    public WeberDbTestCase() {
        if (!initFlg) {
            this.init();
            initFlg = true;
        }
    }

    public void init() {
        try {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            URL diconfigUrl = parent.getResource("di-config.xml");
            if (diconfigUrl == null) {
                String err = "di-config.xml path is null.";
                WeberDbTestCase.fail((String)err);
                log.error(err);
                return;
            }
            String configFwName = diconfigUrl.getPath();
            BeanFactory factory = BeanFactory.getInstance();
            factory.create(configFwName);
            this.mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            this.mgr.init();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            WeberDbTestCase.fail((String)e.getMessage());
            this.mgr.destroy();
        }
    }

    public void tearDown() {
        TransactionUtil.returnTransaction();
    }

    public void initTables(String configName) {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL configUrl = parent.getResource(configName);
        String path = configUrl.getPath();
        DbTestConfigReader dbReader = new DbTestConfigReader();
        try {
            testDataList.clear();
            dbReader.create(path, testDataList);
            this.clearTables();
            this.insertDatas();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            WeberDbTestCase.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void clearTables() {
        Transaction transaction = TransactionUtil.getTransaction();
        if (testDataList.size() == 0) {
            return;
        }
        System.out.println("---- delete data start --- ");
        try {
            try {
                int i = testDataList.size();
                while (i > 0) {
                    TableData table = (TableData)testDataList.get(i - 1);
                    StringBuffer sql = new StringBuffer("Delete From ");
                    sql.append(table.getTableName());
                    System.out.println(sql.toString());
                    transaction.execute(sql.toString());
                    TransactionUtil.commitTransaction();
                    --i;
                }
            }
            catch (Exception e) {
                log.error(String.valueOf(e.getMessage()) + ", Execute role back.");
                TransactionUtil.rollbackTransaction();
                WeberDbTestCase.fail((String)e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            TransactionUtil.returnTransaction();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        TransactionUtil.returnTransaction();
        System.out.println("---- delete data end --- ");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertDatas() {
        Transaction transaction = TransactionUtil.getTransaction();
        System.out.println("---- insert data start --- ");
        try {
            try {
                int i = 0;
                block5: while (true) {
                    if (i >= testDataList.size()) {
                        TransactionUtil.commitTransaction();
                    }
                    TableData table = (TableData)testDataList.get(i);
                    int j = 0;
                    while (true) {
                        if (j >= table.getRecordSize()) {
                            ++i;
                            continue block5;
                        }
                        RecordData record = table.getRecordData(j);
                        StringBuffer sql = new StringBuffer("Insert Into ");
                        sql.append(table.getTableName());
                        sql.append(" ( ");
                        if (record.getFieldSize() != 0) {
                            FieldData field;
                            int k = 0;
                            while (true) {
                                if (k >= record.getFieldSize()) break;
                                field = record.getFieldData(k);
                                sql.append(field.getName());
                                if (k + 1 < record.getFieldSize()) {
                                    sql.append(", ");
                                }
                                ++k;
                            }
                            sql.append(" ) Values ( ");
                            k = 0;
                            while (true) {
                                if (k >= record.getFieldSize()) {
                                    sql.append(" )");
                                    System.out.println(sql.toString());
                                    transaction.execute(sql.toString());
                                    break;
                                }
                                field = record.getFieldData(k);
                                sql.append(field.getValue());
                                if (k + 1 < record.getFieldSize()) {
                                    sql.append(", ");
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error(String.valueOf(e.getMessage()) + ", Execute role back.");
                TransactionUtil.rollbackTransaction();
                WeberDbTestCase.fail((String)e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            TransactionUtil.returnTransaction();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        TransactionUtil.returnTransaction();
        System.out.println("---- insert data end --- ");
    }

    public void assertDoExecute(Action action, Object form, String forward) {
        super.assertDoExecute(action, form, forward);
        int trnStatus = TransactionUtil.getTransaction().getTranStatus();
        if (trnStatus == Transaction.PLEASE_COMMIT) {
            TransactionUtil.commitTransaction();
        } else if (trnStatus == Transaction.PLEASE_ROLLBACK) {
            TransactionUtil.rollbackTransaction();
        }
    }

    public void assertCheckUserRole(Action action, User user, boolean ret) {
        super.assertCheckUserRole(action, user, ret);
        int trnStatus = TransactionUtil.getTransaction().getTranStatus();
        if (trnStatus == Transaction.PLEASE_COMMIT) {
            TransactionUtil.commitTransaction();
        } else if (trnStatus == Transaction.PLEASE_ROLLBACK) {
            TransactionUtil.rollbackTransaction();
        }
    }

    public void assertValidate(Action action, String forward) {
        super.assertValidate(action, forward);
        int trnStatus = TransactionUtil.getTransaction().getTranStatus();
        if (trnStatus == Transaction.PLEASE_COMMIT) {
            TransactionUtil.commitTransaction();
        } else if (trnStatus == Transaction.PLEASE_ROLLBACK) {
            TransactionUtil.rollbackTransaction();
        }
    }
}

