/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.user;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.itscool.commons.property.HexPropertyFile;
import org.itscool.commons.util.AngouUtil;
import org.itscool.weber.user.RoleManager;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserRole;

public class RoleFileManager
implements RoleManager {
    private HashMap roleDefines = new HashMap();
    private HashMap roleFiles = new HashMap();
    private static RoleFileManager instance = null;

    public static RoleFileManager getInstance() {
        if (instance == null) {
            instance = new RoleFileManager();
        }
        return instance;
    }

    private RoleFileManager() {
    }

    public void init() throws IOException {
        Set keySet = this.roleDefines.keySet();
        Iterator it = keySet.iterator();
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            String roleFileName = (String)this.roleDefines.get(roleName);
            URL url = parent.getResource(roleFileName);
            String roleFilePath = url.getFile();
            UserRole role = new UserRole();
            role.setName(roleName);
            HexPropertyFile roleFile = new HexPropertyFile(roleFilePath);
            this.roleFiles.put(roleName, roleFile);
        }
    }

    public boolean isUserCheck(HashMap roles, User user) {
        if (user == null) {
            return false;
        }
        if (roles == null || roles.size() == 0) {
            return this.isRoles(user);
        }
        return this.isRoles(roles, user);
    }

    public void reload() {
        Set keySet = this.roleFiles.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
            if (roleFile == null) {
                throw new RuntimeException("file not found for roleName[" + roleName + "]");
            }
            try {
                roleFile.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List getAllData() {
        ArrayList<User> users = new ArrayList<User>();
        Set keySet = this.roleFiles.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
            Hashtable dataList = roleFile.getDataList();
            Enumeration enumObj = dataList.keys();
            while (enumObj.hasMoreElements()) {
                String userName = (String)enumObj.nextElement();
                byte[] pwd = (byte[])dataList.get(userName);
                String pwdStr = "";
                try {
                    pwdStr = AngouUtil.decrypt((String)userName, (byte[])pwd);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
                User user = new User();
                user.setName(userName);
                user.setPwd(pwdStr);
                users.add(user);
            }
        }
        return users;
    }

    public User getUser(String roleName, String userName) {
        HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
        if (roleFile == null) {
            throw new RuntimeException("file not found for roleName[" + roleName + "]");
        }
        byte[] pwd = roleFile.readHex(userName);
        String pwdStr = "";
        try {
            pwdStr = AngouUtil.decrypt((String)userName, (byte[])pwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        User user = new User();
        user.setName(userName);
        user.setPwd(pwdStr);
        UserRole userRole = new UserRole();
        userRole.setName(roleName);
        user.setRole(userRole);
        return user;
    }

    public HashMap getUsers(String roleName) {
        HexPropertyFile pFile = (HexPropertyFile)this.roleFiles.get(roleName);
        Hashtable dataList = pFile.getDataList();
        HashMap<String, User> users = new HashMap<String, User>();
        Enumeration enumObj = dataList.keys();
        while (enumObj.hasMoreElements()) {
            String userName = (String)enumObj.nextElement();
            byte[] pwd = (byte[])dataList.get(userName);
            String pwdStr = "";
            try {
                pwdStr = AngouUtil.decrypt((String)userName, (byte[])pwd);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            User user = new User();
            user.setName(userName);
            user.setPwd(pwdStr);
            users.put(userName, user);
        }
        return users;
    }

    public void delete(String roleName, String name) throws IOException {
        User user = new User();
        user.setName(name);
        this.delete(roleName, user);
    }

    public synchronized void delete(String roleName, User user) throws IOException {
        String userName = user.getName();
        HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
        if (roleFile == null) {
            throw new RuntimeException("file not found for roleName[" + roleName + "]");
        }
        roleFile.delete(userName);
        this.reload();
    }

    public synchronized boolean add(String roleName, User user) throws IOException {
        String userName = user.getName();
        String pwd = user.getPwd();
        byte[] pwdAngou = AngouUtil.encrypt((String)userName, (String)pwd);
        HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
        if (roleFile == null) {
            throw new RuntimeException("file not found for roleName[" + roleName + "]");
        }
        if (!roleFile.writeHex(userName, pwdAngou, true)) {
            return false;
        }
        this.reload();
        return true;
    }

    public boolean add(String roleName, String name, String pwd) throws IOException {
        User user = new User();
        user.setName(name);
        user.setPwd(pwd);
        return this.add(roleName, user);
    }

    public synchronized void update(String roleName, User user) throws IOException {
        this.delete(roleName, user);
        this.add(roleName, user);
    }

    private boolean isRoles(HashMap roles, User user) {
        Set keySet = roles.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String roleName = (String)roles.get(key);
            HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
            boolean ret = this.isRole(roleFile, user);
            if (!ret) continue;
            UserRole userRole = new UserRole();
            userRole.setName(roleName);
            user.setRole(userRole);
            return true;
        }
        return false;
    }

    private boolean isRoles(User user) {
        Set keySet = this.roleFiles.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            HexPropertyFile roleFile = (HexPropertyFile)this.roleFiles.get(roleName);
            boolean ret = this.isRole(roleFile, user);
            if (!ret) continue;
            UserRole userRole = new UserRole();
            userRole.setName(roleName);
            user.setRole(userRole);
            return true;
        }
        return false;
    }

    private boolean isRole(HexPropertyFile roleFile, User user) {
        boolean ret = false;
        byte[] chkPwd = null;
        String userName = user.getName();
        String pwd = user.getPwd();
        try {
            chkPwd = roleFile.readHex(userName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (chkPwd == null) {
            return ret;
        }
        String chkPwdStr = new String();
        try {
            chkPwdStr = AngouUtil.decrypt((String)userName, (byte[])chkPwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (chkPwdStr == null || chkPwdStr.length() == 0) {
            return ret;
        }
        if (chkPwdStr.equals(pwd)) {
            ret = true;
        }
        return ret;
    }

    public HashMap getRoleDefines() {
        return this.roleDefines;
    }

    public void setRoleDefines(HashMap roleMaps) {
        this.roleDefines = roleMaps;
    }
}

