/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.threadpool;

import org.itscool.commons.threadpool.FIFOQueue;

public final class WorkerThread
extends Thread {
    private static int count;
    private int workerId = count++;
    private int used;
    private boolean stopFlag = false;
    private FIFOQueue queue;
    private long timeWorked;
    private long timeIdle;
    private boolean waitStatus;
    public static final boolean WAIT = true;
    public static final boolean AN_WAIT = false;

    public void setWaitStatus() {
        this.waitStatus = true;
    }

    public void unsetWaitStatus() {
        this.waitStatus = false;
    }

    public boolean getWaitStatus() {
        return this.waitStatus;
    }

    public WorkerThread(FIFOQueue queue) {
        this.queue = queue;
        this.start();
    }

    public void run() {
        while (!this.stopFlag) {
            long start = System.currentTimeMillis();
            Runnable r = (Runnable)this.queue.fetch(this);
            long stop = System.currentTimeMillis();
            this.timeIdle += stop - start;
            r.run();
            this.timeWorked += System.currentTimeMillis() - stop;
            ++this.used;
        }
    }

    public void setStopped() {
        this.stopFlag = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Thread # ");
        sb.append(this.workerId);
        sb.append(" \nUsage :\t");
        sb.append(" Time Idle   : " + this.timeIdle + " ms");
        sb.append(" Time Worked : " + this.timeWorked + " ms");
        sb.append(" No of jobs  : " + this.used);
        return sb.toString();
    }

    public synchronized long getTimeIdle() {
        return this.timeIdle;
    }

    public synchronized long getTimeWorked() {
        return this.timeWorked;
    }

    public synchronized int getJobsDone() {
        return this.used;
    }
}

