/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.collection.InitParamMap;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.util.FileUtil;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.el.LayoutRegex;
import org.itscool.stylist.io.HtmlConfigReader;
import org.itscool.stylist.io.HtmlConverter;
import org.itscool.stylist.io.LayoutConfigReader;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutMappings;
import org.itscool.stylist.mapping.LayoutPutMapping;
import org.itscool.stylist.tag.HtmlRootTag;

public class HtmlLayoutServlet
extends HttpServlet {
    protected AbstractLog log;
    protected ServletContext context = null;
    protected HashMap cacheMap = new HashMap();

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
        BeanFactory factory = BeanFactory.getInstance();
        if (!factory.isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        try {
            this.log = (AbstractLog)factory.getInstance("Log");
            if (!this.log.isInit()) {
                this.log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception ioe) {
            this.log = SimpleLog.getInstance();
            this.log.info(ioe.getMessage());
        }
        LayoutMappings includeMappings = LayoutMappings.getInstance();
        try {
            InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
            String stylistConf = params.getParam("stylist-config");
            if (stylistConf == null) {
                String msg = "no define \"stylist-config\" path from diconfig.xml[InitParams]";
                this.log.info(msg);
            } else {
                LayoutConfigReader includeReader = new LayoutConfigReader();
                includeReader.setConfigName(stylistConf);
                includeReader.create(includeMappings);
            }
        }
        catch (Exception ioe) {
            this.log.error(ioe);
        }
    }

    public void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.execute(arg0, arg1);
    }

    public void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.execute(arg0, arg1);
    }

    protected void execute(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.process(req, res);
        }
        catch (IOException e) {
            String name1 = e.getClass().getName();
            String name2 = IOException.class.getName();
            this.exception(req, res, name1, name2, e);
            throw e;
        }
        catch (ServletException e) {
            String name1 = ((Object)((Object)e)).getClass().getName();
            String name2 = ServletException.class.getName();
            this.exception(req, res, name1, name2, (Exception)((Object)e));
            throw e;
        }
        catch (NullPointerException e) {
            String name1 = e.getClass().getName();
            String name2 = NullPointerException.class.getName();
            this.exception(req, res, name1, name2, e);
            throw e;
        }
        catch (RuntimeException e) {
            String name1 = e.getClass().getName();
            String name2 = RuntimeException.class.getName();
            this.exception(req, res, name1, name2, e);
            throw e;
        }
        catch (Exception e) {
            String name1 = e.getClass().getName();
            String name2 = Exception.class.getName();
            this.exception(req, res, name1, name2, e);
            throw new ServletException(e.getMessage());
        }
        catch (Error e) {
            String name1 = e.getClass().getName();
            String name2 = Exception.class.getName();
            this.exception(req, res, name1, name2, e);
            throw e;
        }
    }

    protected void process(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = this.context.getRealPath(req.getServletPath());
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if (encode == null) {
            this.log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        HtmlRootTag html = (HtmlRootTag)this.cacheMap.get(path);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if (html == null || html.getLastModified() != FileUtil.getLastModified((String)path)) {
            html = new HtmlRootTag(encode);
            reader.create(path, html);
            this.cacheMap.put(path, html);
            this.log.trace("HtmlTag instance is created");
        } else {
            this.log.trace("HtmlTag instance geted from chache");
        }
        this.log.trace(html.toString(0, ""));
        HtmlConverter converter = new HtmlConverter();
        converter.init(this.context, req);
        String convStr = html.getXml() + System.getProperty("line.separator");
        convStr = convStr + html.getDtd() + System.getProperty("line.separator");
        convStr = convStr + converter.convert(html);
        convStr = new String(convStr);
        LayoutRegex regex = new LayoutRegex(this.context, req);
        convStr = regex.replacePath(convStr);
        String servletPath = req.getServletPath();
        String layoutName = this.layout(servletPath, req);
        if (layoutName != null) {
            TagInfo body = TagUtil.createTagInfo((String)convStr, (String)"body");
            TagInfo head = TagUtil.createTagInfo((String)convStr, (String)"head");
            if (body != null) {
                req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)body.getDataInTag());
                if (head != null) {
                    req.setAttribute("org.itscool.stylist.include.INCLUDE.head", (Object)head.getDataInTag());
                }
            } else {
                req.setAttribute("org.itscool.stylist.include.INCLUDE.body", (Object)convStr);
            }
            String contextPath = req.getServerName();
            int port = req.getServerPort();
            String layoutPath = this.context.getRealPath(layoutName);
            HtmlRootTag layoutTag = new HtmlRootTag(encode);
            HtmlConfigReader layoutReader = new HtmlConfigReader();
            layoutReader.setDefaultEncode(encode);
            layoutReader.create(layoutPath, layoutTag);
            convStr = converter.convert(layoutTag);
            if (body != null) {
                String bodyTagStr = body.getStartTag();
                Pattern pattern = Pattern.compile("<body>");
                Matcher matcher = pattern.matcher(convStr);
                convStr = matcher.replaceAll(body.getStartTag());
            }
        }
        if (!res.isCommitted()) {
            res.reset();
            this.initSessionTimeout(req, res);
        }
        res.setContentType("text/html; charset=" + encode);
        PrintWriter writer = res.getWriter();
        writer.write(convStr);
        writer.flush();
        writer.close();
    }

    protected String layout(String path, HttpServletRequest req) throws IOException, ServletException {
        LayoutMappings mappings = LayoutMappings.getInstance();
        LayoutMapping include = (LayoutMapping)mappings.get(path);
        if (include == null) {
            return null;
        }
        String extendz = include.getExtendz();
        if (extendz != null) {
            this.checkParentLayout(include, req);
        }
        String layoutPath = include.getPath();
        HashMap putMap = include.getPuts();
        if (putMap != null) {
            Set keySet = putMap.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                LayoutPutMapping put = (LayoutPutMapping)putMap.get(name);
                this.setIncludeContents(put, name, req);
            }
        }
        return layoutPath;
    }

    protected void checkParentLayout(LayoutMapping layout, HttpServletRequest req) throws IOException, ServletException {
        HashMap putMap;
        LayoutMappings mappings = LayoutMappings.getInstance();
        String parentName = layout.getExtendz();
        String extendz = layout.getExtendz();
        if (extendz != null) {
            LayoutMapping parent = (LayoutMapping)mappings.get(parentName);
            this.checkParentLayout(parent, req);
        }
        if ((putMap = layout.getPuts()) == null) {
            return;
        }
        Set keySet = putMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            LayoutPutMapping put = (LayoutPutMapping)putMap.get(name);
            this.setIncludeContents(put, name, req);
        }
    }

    protected void setIncludeContents(LayoutPutMapping put, String attrName, HttpServletRequest req) throws IOException {
        String layoutName = put.getPath();
        String contextPath = req.getServerName();
        int port = req.getServerPort();
        String layoutPath = this.context.getRealPath(layoutName);
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        if (encode == null) {
            this.log.warn("No set inita param[encoding] default set[Shift_JIS]");
            encode = "Shift_JIS";
        }
        HtmlRootTag layoutTag = (HtmlRootTag)this.cacheMap.get(layoutPath);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.setDefaultEncode(encode);
        if (layoutTag == null || layoutTag.getLastModified() != FileUtil.getLastModified((String)layoutPath)) {
            layoutTag = new HtmlRootTag(encode);
            reader.create(layoutPath, layoutTag);
            this.cacheMap.put(layoutPath, layoutTag);
            this.log.trace("HtmlTag(layout) instance is created");
        } else {
            this.log.trace("HtmlTag(layout) instance geted from chache");
        }
        HtmlConverter converter = new HtmlConverter();
        converter.init(this.context, req);
        String convStr = converter.convert(layoutTag);
        TagInfo body = TagUtil.createTagInfo((String)convStr, (String)"body");
        if (body != null) {
            req.setAttribute("org.itscool.stylist.include.INCLUDE." + attrName, (Object)body.getDataInTag());
        } else {
            req.setAttribute("org.itscool.stylist.include.INCLUDE." + attrName, (Object)convStr);
        }
    }

    protected void initSessionTimeout(HttpServletRequest req, HttpServletResponse res) {
        HttpSession session = req.getSession();
        if (session.isNew()) {
            String sessionId = session.getId();
            Cookie[] cookies = req.getCookies();
            Cookie accesstimeCookie = null;
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals("JSESSIONID")) continue;
                    accesstimeCookie = cookies[i];
                }
            }
            Cookie cookie = new Cookie("JSESSIONID", sessionId);
            cookie.setMaxAge(604800);
            res.addCookie(cookie);
        }
    }

    protected void exception(HttpServletRequest req, HttpServletResponse res, String exceptionName1, String exceptionName2, Exception e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        this.log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        for (int i = 0; i < traceList.length; ++i) {
            StackTraceElement trace = traceList[i];
            this.log.error(trace.toString());
        }
    }

    protected void exception(HttpServletRequest req, HttpServletResponse res, String exceptionName1, String exceptionName2, Error e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        this.log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        for (int i = 0; i < traceList.length; ++i) {
            StackTraceElement trace = traceList[i];
            this.log.error(trace.toString());
        }
    }
}

