package test.org.itscool.commons.dao3;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.weber.testcase.WeberDbTestCase;

public class DataTypeDaoTest extends WeberDbTestCase{
    public void setUp(){
        this.clearTables();
        this.initTables("test/org/itscool/commons/dao3/test-db-data.xml");
    }
    
    
    public void testInsert(){
        DataTypeBean company = new DataTypeBean();
        byte[] byteArray = new byte[2];
        byteArray[0] = 10;
        byteArray[1] = 20;
        
        company.setId(1);
        company.setByteArray(byteArray);
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DataTypeBean.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            dao.insert(crt, company);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
        }catch( Exception e ){
            e.printStackTrace();
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
        
        try{
            if(Transaction.PLEASE_COMMIT == trn.getTranStatus()){
                TransactionUtil.commitTransaction();
            }else if(Transaction.PLEASE_ROLLBACK == trn.getTranStatus()){
                TransactionUtil.rollbackTransaction();
            }
        }catch( Exception e){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
    
}
