/*
 * ElementListTest.java
 *
 * Created on 2007/03/19, 13:51
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.stylist.el;

import junit.framework.TestCase;
import org.itscool.stylist.el.ElementList;

public class ElementListTest extends TestCase{
    
    public void testCreateElementList(){
        String el1 = "hello.name";
        ElementList list = ElementList.createElementList(el1);
        assertEquals("tagString", list.getTagString(), el1);
        assertEquals("tag1", "hello", list.get(0));
        assertEquals("tag2", "name", list.get(1));
        assertEquals("list count", 2, list.size());
        
    }
    
    public void testCreateElementList2(){
        String el1 = "a.b.c.d.e";
        ElementList list = ElementList.createElementList(el1);
        assertEquals("tagString", list.getTagString(), el1);
        assertEquals("tag1", "a", list.get(0));
        assertEquals("tag2", "b", list.get(1));
        assertEquals("tag3", "c", list.get(2));
        assertEquals("tag4", "d", list.get(3));
        assertEquals("tag5", "e", list.get(4));
        assertEquals("list count", 5, list.size());
        
    }
    
    public void testCreateElementList3(){
        String el1 = "hello_name";
        ElementList list = ElementList.createElementList(el1);
        assertEquals("tagString", list.getTagString(), el1);
        assertEquals("tag1", "hello_name", list.get(0));
        assertEquals("list count", 1, list.size());
    }
    
    public void testCreateElementList4(){
        String el1 = "hello.name.";
        ElementList list = ElementList.createElementList(el1);
        assertEquals("tagString", list.getTagString(), el1);
        assertEquals("tag1", "hello", list.get(0));
        assertEquals("tag2", "name", list.get(1));
        assertEquals("list count", 2, list.size());
        
    }
    
    public void testCreateElementList5(){
        String el1 = "hello.name.. . ";
        ElementList list = ElementList.createElementList(el1);
        assertEquals("tagString", list.getTagString(), el1);
        assertEquals("tag1", "hello", list.get(0));
        assertEquals("tag2", "name", list.get(1));
        assertEquals("list count", 2, list.size());
        
    }
}
