package org.itscool.commons.threadpool;

/**
 * This class represents the Worker Thread in the Thread Pool.<BR>
 * ̃NX́AXbhEv[ŘJ҃Xbh\B<BR>
 * @author Ashwin Desai.
 * @version 1.10A 2002.06.23 [ [ stopFlg̎gpL
 */
public final class WorkerThread extends Thread {
    /** ID Generator */
    private static int count;
    /** WorkerThred's ID */
    private int workerId;
    /** Number of Jobs. */
    private int used;
    /** Stop Flag */
    private boolean stopFlag = false;
    /** Request Buffer.(FIFOFo) */
    private FIFOQueue queue;
    /** Debug and Usage stats. */
    private long timeWorked;
    /** Debug and Usage stats.(fobOƎgpvj*/
    private long timeIdle;
    /** Xbh̑҂ */
    private boolean waitStatus;
    /** ҂ */
    public static final boolean WAIT = true;
    /** ҂ԂłȂ */
    public static final boolean AN_WAIT = false;

    /**
    * ҂Ԃ̃Zbg
    * gpsynchronizedgƁB
    */
    public void setWaitStatus() {
        this.waitStatus = true;
    }

    /**
    * Xbh̑҂ԂAZbg
    * gpsynchronizedgƁB
    */
    public void unsetWaitStatus() {
        this.waitStatus = false;
    }

    /**
    * Xbh̑҂Ԃ擾
    * @return boolean trueF҂
    */
    public boolean getWaitStatus() {
        return this.waitStatus;
    }

    /**
     * Creates a WorkerThread object with a shared request queue as parameter.
     * p[^[ƂċLꂽNGXgEL[WorkerThreadIuW
     * FNgo܂B
     */
    public WorkerThread(FIFOQueue queue) {
        workerId = count++;
        this.queue = queue;
        this.start();
    }

    /**
     * The actual work.(ۂ̎d)
     * <pre>
     *  while( thread IS NOT stopped )
     *  {
     *            Get the next request from the queue (this blocks if the queue is empty).
     *            Serve the request.
     *          L[玟̃NGXg󂯎ĉ
     *          (L[ۂȂAꂪǂ܂)B
     *           NGXgoĉB
     *  }
     * </pre>
     */
    public void run() {
        while ( !stopFlag ) {
            //            System.out.println("Thread #" + workerId + "waiting. ....");
            long start = System.currentTimeMillis();
            Runnable r = (Runnable) queue.fetch(this);
            long stop = System.currentTimeMillis();
            timeIdle += (stop - start);
            //            System.out.println("Thread #" + workerId + "working ....");
            r.run();
            //            System.out.println("Thread #" + workerId + "DONE !!");
            timeWorked += (System.currentTimeMillis() - stop);
            // Increment the Usage statistics of this thread
            //(̃Xbh̎gpvlCNgB)
            used++;
        }
    }

    /**
     * Stops the Thread work. i.e. this thread exits it's run() method gracefully.
     * ꂪDrun ()\bhłXbhdBȂ킿̃XbhIXgbvB
     */
    public void setStopped() {
        stopFlag = true;
    }

    /**
     * Debug info.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("Thread # ");
        sb.append(workerId);
        sb.append(" \nUsage :\t");
        sb.append(" Time Idle   : " + timeIdle + " ms");
        sb.append(" Time Worked : " + timeWorked + " ms");
        sb.append(" No of jobs  : " + used);
        return sb.toString();
    }

    /** These methods are for usage stats and debug **/
    /** ̃\bh́Agv̂߂ɂāAăfobO܂ **/
    public synchronized long getTimeIdle() {
        return timeIdle;
    }

    public synchronized long getTimeWorked() {
        return timeWorked;
    }

    public synchronized int getJobsDone() {
        return used;
    }

}
