package org.itscool.weber.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.collection.InitParamMap;
import org.itscool.weber.action.*;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.GeneralFormFactory;
import org.itscool.commons.request.UploadFile;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.weber.io.ActionConfigReader;
import org.itscool.weber.io.ExceptionConfigReader;
import org.itscool.weber.io.MessageConfigReader;
import org.itscool.weber.mapping.ActionMapping;
import org.itscool.weber.mapping.ActionMappings;
import org.itscool.weber.mapping.ExceptionMapping;
import org.itscool.weber.mapping.ExceptionMappings;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.UserManager;

/**
 * FrontControllerp^[ɊÂFrontServletNXł<BR>
 * NCAg甭NGXǵA܂Controller̋@\𐿂
 * FrontServlet󂯎܂B<br>
 * FrontServletMVCfC̖R|[lgłB<BR>
 * ̃t[[Nł́AЂƂ̃AvP[VňFrontServlet
 * NXSẴNGXg܂B<BR>
 * FrontServlet͂̃t[[NŎgpeR|[lgAg
 * AvP[VŜ̐sR|[lgłAJ҂͌Ƃ
 * ڈKv͂܂B<BR>
 * <p>
 *yFrontServletƊ֘ANXz<BR>
 * <table border="1" width="500">
 *     <tr><td>
 *     <font face="lr SVbN" size="3">
 *     <br>
 *     @+--------+ (1)@+------------+@@@+----------+<br>
 *     @|@@@@|----->|@Front @@| (2)@|@Action@|<br>
 *     @|@Web @| (7)@|@Servlet @|----->|@Mapping |<br>
 *     @|@@@@|<-----|@@@@@@|@@@|@@@@@|<br>
 *     @+--------+@@@+------------+@@@+----------+<br>
 *     @@@@@@@@@@@A @|@|<br>
 *     @@@@@@@@@@@| @|@|@@@@@@@@@@<br>
 *     @@@@@@@@@@@| @|@|(3)+------------+<br>
 *     @@@@@@@@@@@| @|@+-->|@@@@@@|<br>
 *     @@@@@@@@@@@| @|@@@|@ Bean@ @|<---+   <br>
 *     @@@@@@@@@@@| @|@@@|@@@@@@|@@|   <br>
 *     @@@@@@@@@@@| @|@@@+------------+@@|   <br>
 *     @@@@@@@@@@@| @|@@@@@@@@@@@@|(5)<br>
 *     @@@@@@@@@@@| @| (4)@+------------+@@|   <br>
 *     @@@@@@@@@@@| @+----->|@@@@@@|@@|   <br>
 *     @@@@@@@@@@@| @@(6)@|@ Action @|----+   <br>
 *     @@@@@@@@@@@+----------|@@@@@@|<br>
 *     @@@@@@@@@@@@@@@@ +------------+<br>
 *     </font>
 * <br>
 * </td></tr>
 * </table>
 * <p>
 *y̐z<br>
 * <table border="1" width="500">
 *
 *     <tr>
 *         <td width="40" align="center">No</td><td></td>
 *     </tr>
 *     <tr>
 *         <td align="center">1</td>
 *         <td>
 *         NCAg甭NGXgFrontServletNX󂯎܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">2</td>
 *         <td>
 *         FrontServlet̓NCAg󂯎NGXgURIActionMapping
 *         擾܂<br>
 *         ActionMappingɂ̓NGXgURIɊ֘AActionNXyуtH[Bean
 *         o^Ă܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">3</td>
 *         <td>
 *         FrontServletNXActionMappingNXBeanIuWFNg𐶐A
 *         NCAg̃NGXgp[^BeanIuWFNgɃZbg܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">4</td>
 *         <td>
 *         FrontServletNXActionMappingNXAction𐶐܂B<br>
 *         ɐActionɑ΂execute\bhs܂B<BR>
 *         execute\bḧɂ́AtH[Bean̑HttpServletReqeust
 *         CX^XHttpServletResponceCX^X܂܂܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">5</td>
 *         <td>
 *         ActionNX̓NCAg̃NGXgp[^BeanIuWFNg
 *         擾܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">6</td>
 *         <td>
 *         NGXgp[^ɏ]āArWlXWbN܂<br>
 *         Action̎sʂFrontServletɕԋp܂<br>
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">7</td>
 *         <td>
 *         FrontServletAction̎sʂJSPy[W쐬A
 *      NCAgɕԋp܂
 *         </td>
 *     </tr>
 * </table>
 * <p>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 * @version 1.10A 2004/12/11 Include@\ǉ
 * @version 1.11A 2005/05/20 Include@\폜iStylistƂ̕j
 * @version 1.20A 2005/05/29 FileUploadΉ
 */
public class FrontServlet extends HttpServlet {
    protected AbstractLog log;
    
    /**
     * FrontServlet̏
     * @see javax.servlet.GenericServlet#init()
     */
    public void init(ServletConfig config) throws ServletException {
        BeanFactory factory = BeanFactory.getInstance();
        if( !factory.isInit() ){
            try{
                factory.createForUrl("di-config.xml");
            }catch(Exception ex){
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        
        try{
            log = (AbstractLog)factory.getInstance("Log");
            if(!log.isInit()){
                log = (AbstractLog)factory.createInstance("Log");
            }
        }catch(Exception ioe){
            log = SimpleLog.getInstance();
            log.info(ioe.getMessage());
        }
        
        initConfig(factory);
        
    }
    
    /**
     * T[ubgƂɌĂ΂܂<br>
     * f[^ݒ肵܂
     * @param factory di-config.xmlt@C珉ݒ擾CX^X
     */
    protected void initConfig(BeanFactory factory) throws ServletException{
        try{
            ActionMappings actionMappings = ActionMappings.getInstance();
            ExceptionMappings exception = ExceptionMappings.getInstance();
            MessageMappings messages = MessageMappings.getInstance();

            InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
            //K{
            String weberConf=params.getParam("weber-config");
            if(weberConf==null){
                String msg = "no define \"weber-config\" path from diconfig.xml[InitParams]";
                log.error(msg);
                throw new IOException(msg);
            }
            //CӍ
            String msgConf=params.getParam("message-config");
            XmlConfigReader actionReader = new ActionConfigReader();
            actionReader.setConfigName(weberConf);
            actionReader.create(actionMappings);
            
            try{
                XmlConfigReader exceptionReader = new ExceptionConfigReader();
                exceptionReader.setConfigName(weberConf);
                exceptionReader.create(exception);
            }catch(Exception ioe){
                log.info("ExceptionConfigReader͎s܂");
            }
            
            try{
                XmlConfigReader messageReader = new MessageConfigReader();
                messageReader.setConfigName(msgConf);
                messageReader.create(messages);
            }catch(Exception ioe){
                log.info("MessageConfigReader͎s܂");
            }
            try{
                EntityInfoMapping daoMapping = (EntityInfoMapping)factory.createInstance("EntityInfoMapping");
            }catch(Exception ioe){
                log.info("DaoConfigReader͎s܂");
            }
            try{
                UserManager roleManager = (UserManager)factory.createInstance("UserManager");
                roleManager.init();
            }catch(Exception ioe){
                log.info("WeberUserManager͎s܂");
            }
            
        }catch(Exception e){
            String name1 = e.getClass().getName();
            String name2 = Exception.class.getName();
            StackTraceElement[] traceList = e.getStackTrace();
            log.error(getStackTrace(traceList));
            throw new ServletException(e.getMessage());
        }
    }
    
    /**
     * doGet܂
     * @see javax.servlet.http.HttpServlet#doGet(
     *         javax.servlet.http.HttpServletRequest,
     *         javax.servlet.http.HttpServletResponse)
     */
    public void doGet(HttpServletRequest arg0, HttpServletResponse arg1)
    throws ServletException, IOException {
        execute(arg0, arg1);
    }
    
    /**
     * doPost܂
     * @see javax.servlet.http.HttpServlet#doPost(
     *         javax.servlet.http.HttpServletRequest,
     *         javax.servlet.http.HttpServletResponse)
     */
    public void doPost(HttpServletRequest arg0, HttpServletResponse arg1)
    throws ServletException, IOException {
        execute(arg0, arg1);
    }
    
    /**
     * doGet()AdoPost()\bh̏s邽߂execute\bhĂт܂<br>
     * executes̓\bh߂lɃZbgꂽJSPɑJڂ܂B<BR>
     * VXeOꍇexception\bhĂяo܂B
     * @param req HttpNGXgCX^X
     * @param res HttpX|XCX^X
     */
    private void execute(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException {
        try {
            String jsp = invoke(req, res);
            if(jsp.equals(Globals.RET_NOFORWARD)){
                return;
            }
            //==========================================================================================
            //jspԐM
            //==========================================================================================
            //** servlet̏init()ōsꍇ͂
            //ServletContext sc = this.getServletContext();
            //RequestDispatcher rd = sc.getRequestDispatcher(jsp);
            //rd.forward(req, res);
            //** servlet̏init(ServletConfig config)ōsꍇ͂
            try{
                RequestDispatcher rd = req.getRequestDispatcher(jsp);
                rd.forward(req, res);
            }catch(IOException e){
                String msg = jsp + "Ɏw肳ꂽRečďoŃG[܂\n" + e.getMessage();
                throw new IOException(msg);
            }
        } catch (IOException e) {
            String name1 = e.getClass().getName();
            String name2 = IOException.class.getName();
            if (!exception(req, res, name1, name2, e)) {
                throw e;
            }
        } catch (ServletException e) {
            String name1 = e.getClass().getName();
            String name2 = ServletException.class.getName();
            if (!exception(req, res, name1, name2, e)) {
                throw e;
            }
        } catch (NullPointerException e) {
            String name1 = e.getClass().getName();
            String name2 = NullPointerException.class.getName();
            if (!exception(req, res, name1, name2, e)) {
                throw e;
            }
        } catch (RuntimeException e) {
            String name1 = e.getClass().getName();
            String name2 = RuntimeException.class.getName();
            if (!exception(req, res, name1, name2, e)) {
                throw e;
            }
        } catch (Exception e) {
            String name1 = e.getClass().getName();
            String name2 = Exception.class.getName();
            if (!exception(req, res, name1, name2, e)) {
                throw new ServletException(e.getMessage());
            }
        } catch (Error e){
            String name1 = e.getClass().getName();
            String name2 = Exception.class.getName();
            if (!exception(req, res, name1, name2, e)) {
                throw new ServletException(e.getMessage());
            }
        }
    }
    
    /**
     * ƖĂяo܂
     * @param req HttpServletRequestCX^X
     * @param res HttpServletResponseCX^X
     * @return sʂ\URLԂ܂
     */
    protected String invoke(HttpServletRequest req, HttpServletResponse res)
    throws Exception{
        String jsp = process(req, res);
        return jsp;
    }
    
    /**
     * doGet()AdoPost()\bh̏s܂                          <BR>
     * FrontServletNX́A󂯎NGXgpXw̃ANV
     * tH[BeanCX^X𐶐܂B                               <BR>
     * NGXgpXƃANVyуtH[BeanƂ̊t
     * /WEB-INF/itscool-config.xml<action-mappings>vfŒ`܂B     <BR>
     *
     *                                                                      <P>
     * y`t@C̋Lqz                                             <BR>
     * <font size="2">                                                      <BR>
     * &lt;action-mappings&gt;                                              <BR>
     * @&lt;!-- OCANV --&gt;                                  <BR>
     * @&lt;action                                                         <BR>
     * @@&lt;-- OCs̃NGXgpXw肵܂B --&gt;       <BR>
     * @@path="/login.do"                                                 <BR>
     * @@&lt;-- NGXgɑΉANVNXݒ --&gt;         <BR>
     * @@type="org.itscoolSample.action.LoginAction"&gt;                  <BR>
     * @@&lt;-- tH[ɃZbgp[^`FbN                <BR>
     * @@@@@NXݒ ---&gt;                                   <BR>
     * @@&lt;-- tH[h̑Jڐݒ --&gt;                           <BR>
     * @@&lt;forward name="success" path="/input.jsp"/&gt;                <BR>
     * @@&lt;forward name="fail" path="/fail.jsp"/&gt;                    <BR>
     * @@&lt;/action&gt;                                                  <BR>
     *                                                                      <BR>
     * @@&lt;-- [̓ANV --&gt;                                 <BR>
     * @@&lt;action                                                       <BR>
     * @@@@path="/input.do"                                             <BR>
     * @@@@type="org.itscoolSample.action.InputAction" &gt;             <BR>
     * @@@@&lt;forward name="success" path="/confirm.jsp"/&gt;          <BR>
     * @@@@&lt;forward name="fail" path="/fail.jsp"/&gt;                <BR>
     * @@&lt;/action&gt;                                                  <BR>
     * &lt;/action-mappings&gt;                                             <BR>
     * </font>                                                              <BR>
     *                                                                      <BR>
     *
     * @param req HttpNGXgCX^X
     * @param res HttpX|XCX^X
     * @return ̑JڐJSPԂ܂
     * @throws Exception proecessɎsƗOExceptionX[܂B
     */
    protected String process( HttpServletRequest req, HttpServletResponse res )
    throws Exception{
        String ret = Globals.RET_SUCCESS;
        String jsp = null;
        String encode = getEncoding();
        
        //==========================================================================================
        //t@C]ʏPOST
        //t@C]̏ꍇ̓ftHgMultipartPostItemsCX^Xԋp
        //ʏPOSTȂSimplePostRequestԋp
        //==========================================================================================
        GeneralFormFactory factory = GeneralFormFactory.getInstance();
        GeneralForm hgForm = factory.create(req, encode);
        
        String path = req.getServletPath();
//add 2005/11/10 kano start
        //pathInfo͒P̃eXgpɎgp
        String pathInfo = req.getPathInfo();
        if(pathInfo != null){
            path = pathInfo;
        }
//add 2005/11/10 kano end
        
        log.trace("---------- servlet infomation!!! --------------- ");
        log.trace("[ServerName]" + req.getServerName() );
        log.trace("[ContextPath]" + req.getContextPath());
        log.trace("[ServletPath]" + req.getServletPath());
        log.trace("[PathInfo]" + req.getPathInfo());
        log.trace("[QueryString]" + req.getQueryString());
        log.trace("[RequestURI]" + req.getRequestURI());
        log.trace("[RequestURL]" + req.getRequestURL());
        
        //input.dosave.dõpXAction擾
        Action action = getAction(req, path);
        if (action == null) {
            String err = "[" + path + "]" + "Can not found action ("
                + FrontServlet.class.getName() + ")";
            throw new ServletException(err);
        }
        
        //======================================================================================
        //[U擾
        //======================================================================================
        HashMap roles = getRoles(path);
        
        //=========================
        //execute()bvNX𐶐
        //=========================
        ActionBucketImpl bucket = new ActionBucketImpl();
        bucket.setServlet(this);
        bucket.setRequest(req);
        bucket.setResponse(res);
//        bucket.setForm(bean);
        bucket.setRoles(roles);
        
        //======================================================================================
        //rWlXWbN̏ƑO
        //======================================================================================
        action.init(bucket, hgForm);
        ret = action.beforeExecute();
        //̓`FbNɂē̓G[̓G[ZbgăG[ʂɑJ
        if( !ret.equals(Globals.RET_SUCCESS) ){
            //̓`FbNɂđJږ󂯂ƂdoExecutesɏI
            if(ret.equals(Globals.RET_NOFORWARD )){
                return ret;
            }
            jsp= getForward(action, ret, path);
//            jsp = action.getForward(ret);
            if (jsp == null) {
                String err = "["  + "ACTION:" + action.getClass().getName()
                    + "NAME:" + ret  + "]" + "Can not found forward ("
                    + FrontServlet.class.getName() + ")";
                throw new ServletException(err);
            }
            return jsp;
        }
        
        //======================================================================================
        //NGXgp[^̃Zbg
        //======================================================================================
        Object bean = getForm(path);
        if (bean == null) {
//modify 2006/01/19 kano start
            //GereralFormΉ(Vv[c)
            bean = (GeneralForm)hgForm;
//modify 2006/01/19 kano end
            //tH[Bean݂ꍇBeanIuWFNgɃp[^Zbg
        }else{
            setRequestParam(bean, hgForm);
        }
        action.setForm(bean);
        
        //======================================================================================
        //rWlXWbN̎s
        //======================================================================================
        ret = action.execute();
        
        //sʂuʑJږv̏ꍇ
        if(ret != null && ret.equals(Globals.RET_NOFORWARD)){
            return Globals.RET_NOFORWARD;
        }
        jsp = getForward(action, ret, path);
        return jsp;
    }
    
    /**
     * GR[h擾܂
     * @return GR[fBO
     */
    protected String getEncoding() {
        //==========================================================================================
        //GR[fBO
        //==========================================================================================
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
//        InitParamMap params = InitParamMap.getInstance();
//        InitParamMap info = InitParamMap.getInstance();
        String encode = (String) params.getParam("encoding");
        return encode;
    }

    /**
     * Ɩs̑JڐURL擾܂
     * @param action ActionCX^X
     * @param ret Action̎s
     * @param path NGXgpX
     */
    protected String getForward(Action action, String ret, String path) throws ServletException {
        String jsp;
        jsp = action.getForward(ret);
        if (jsp == null) {
            String err =  "[ACTION:" + action.getClass().getName()
                + "NAME:" + ret + "] Can not found forward ("
                + FrontServlet.class.getName() + ")";
            throw new ServletException(err);
        }
        return jsp;
    }
    
    /**
     * X^bNg[X𕶎ɕϊ܂
     * @param traceList X^bNg[X
     * return ɕϊꂽX^bNg[X
     */
    protected String getStackTrace(StackTraceElement[] traceList){
        String LINE = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < traceList.length; i++) {
            StackTraceElement trace = traceList[i];
            sb.append(trace.toString()).append(LINE);
        }
        return sb.toString();
    }
    
    /**
     * Oo͂܂<BR
     * Õ͔NXŃLb`ČďoƂ̃NXthrow
     * ƂɂAÕg[XǐՂ鎖ł܂<BR>
     * Õg[XJDK1.4œꂽException.getStackTrace()
     * \bhgėOg[XĂ܂
     * @param e ExceptionCX^X
     * @return G[y[WɑJڂꍇtrueԂ܂
     */
    protected boolean exception(
        HttpServletRequest req,
        HttpServletResponse res,
        String exceptionName1,
        String exceptionName2,
        Exception e)
        throws IOException, ServletException {
        String msg = e.getMessage();
        if( msg == null ){
            msg =e.getClass().getName();
        }
        log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        log.error(getStackTrace(traceList));
        
        //---------------------
        //G[y[W̑Jڔ
        //---------------------
        String jsp = getExceptionPage(e);
        if (jsp != null) {
            req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR_MSG, msg);
            req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR, traceList);
            //getServletContext().getRequestDispatcher(path).forward(req, res);
            RequestDispatcher rd = req.getRequestDispatcher(jsp);
            rd.forward(req, res);
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * Oo͂܂<BR
     * Õ͔NXŃLb`ČďoƂ̃NXthrow
     * ƂɂAÕg[XǐՂ鎖ł܂<BR>
     * Õg[XJDK1.4œꂽException.getStackTrace()
     * \bhgėOg[XĂ܂
     * @param e ExceptionCX^X
     * @return G[y[WɑJڂꍇtrueԂ܂
     */
    protected boolean exception(
        HttpServletRequest req,
        HttpServletResponse res,
        String exceptionName1,
        String exceptionName2,
        Error e)
        throws IOException, ServletException {
        String msg = e.getMessage();
        if( msg == null ){
            msg =e.getClass().getName();
        }
        log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        log.error(getStackTrace(traceList));
//        for (int i = 0; i < traceList.length; i++) {
//            StackTraceElement trace = traceList[i];
//            log.error(trace.toString());
//        }
        
        //---------------------
        //G[y[W̑Jڔ
        //---------------------
        String jsp = getExceptionPage(e);
        if (jsp != null) {
            req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR_MSG, msg);
            req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR, traceList);
            //getServletContext().getRequestDispatcher(path).forward(req, res);
            RequestDispatcher rd = req.getRequestDispatcher(jsp);
            rd.forward(req, res);
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * ȎJڐURL擾܂
     * @param e Exception/ErrorCX^X
     * @return ȎJڐURL
     */
    protected String getExceptionPage(Object e){
        ExceptionMappings mapping = ExceptionMappings.getInstance();
        ExceptionMapping exception = null;
        if(e instanceof Exception){
            exception = mapping.get((Exception)e);
        }else{
            exception = mapping.get((Error)e);
        }
        if( exception == null) return null;
        return exception.getPath();
    }
    
    /**
     * NGXgpXActionCX^X擾܂B
     * @param path NGXgpXw肵܂
     * @return ꂽActionCX^X
     */
    public Action getAction(HttpServletRequest req, String path)
    throws IOException {
        ActionMappings mappings = ActionMappings.getInstance();
        ActionMapping mapping = (ActionMapping) mappings.get(path);
        
        if (mapping == null) {
            String err = "Not found action for path(" + path + ")";
            throw new IOException(err);
        }
        
        Action action = (Action) BeanUtil.createInstance(mapping.getType());
        
        if( log.getLevel().equals(SimpleLog.TRACE) ){
            HashMap roles = mapping.getRoles();
            StringBuffer roleNames = new StringBuffer();
            if( roles != null ){
                Set keySet = roles.keySet();
                Iterator it = keySet.iterator();
                while(it.hasNext()){
                    Object key = it.next();
                    roleNames.append(roles.get(key).toString());
                    if(it.hasNext()){
                        roleNames.append(", ");
                    }
                }
            }else{
                roleNames.append("null");
            }
            log.trace("---------- request recieved!!!!! --------------- ");
            log.trace("PATH   : " + mapping.getPath());
            log.trace("ACTION : " + mapping.getType());
            log.trace("FORM   : " + mapping.getName());
            log.trace("ROLE   : " + roleNames.toString());
        }
        action.setForwards(mapping.getForwards());
        action.setValidates(mapping.getValidates());
        return action;
    }
    
    /**
     * NGXgpXFormBeanCX^X擾܂B
     * @param path NGXgpXw肵܂
     * @return ꂽFormBeanCX^X
     */
    public Object getForm(String path) throws IOException{
        ActionMappings mappings = ActionMappings.getInstance();
        ActionMapping mapping = (ActionMapping) mappings.get(path);
        String beanName = mapping.getName();
        
        if (beanName == null)
            return null;
        Object bean = (Object) BeanUtil.createInstance(beanName);
        //setRequestParam(req, bean);
        
        return bean;
    }
    
    /**
     * NGXgp[^擾IuWFNgBeanɃp[^Zbg܂
     * @param bean ZbgΏۂƂȂIuWFNgn܂i\bhśAp[^
     * ZbgꂽIuWFNgԂ܂j
     * @param gForm HttpServletRequest̃p[^Zbg
     */
    public void setRequestParam(Object bean, GeneralForm gForm) throws IOException{
        Set keySet = gForm.keySet();
        Iterator it = keySet.iterator();
        
        if( it.hasNext() ){
            log.trace("---------- request parameter!!!! --------------- ");
        }
        
        while( it.hasNext() ){
            String paramName = (String)it.next();
            Object paramValue = gForm.getParameter(paramName);
            try {
                //p[^̌^擾
                Class clazz = BeanUtil.getReturnType(bean, paramName);
                //`FbN{bNXΉ
                //`FbN{bNXwɂāAP̃f[^I
                //Ȃꍇ̑Ή
                if(List.class.isAssignableFrom(clazz)
                && !List.class.isAssignableFrom(paramValue.getClass())){
                    ArrayList list = new ArrayList();
                    list.add(paramValue);
                    
//                    log.info("p[^["+paramName+"] ̃p[^͕݂邽ListC^[tF[XŃZbg܂");
                    
                    BeanUtil.setProperty(bean, paramName, list);
                    
                }else if(Date.class.isAssignableFrom(clazz) && paramValue instanceof String){
                    Date date = DateFormatUtil.parse(paramValue.toString());
                    BeanUtil.setProperty(bean, paramName, date);
                    
                }else if(paramValue instanceof String || paramValue instanceof UploadFile
                    || paramValue instanceof List){
                    
                    //Abv[hꂽt@CUploadFileŃZbg
                    //̂ŎMBeanɂUploadFile^ϐƑΉANZbT\bh
                    //KvI
                    BeanUtil.setProperty(bean, paramName, paramValue);
                }else{
                    throw new ClassCastException(paramName + " is not match ["
                        + clazz.getName() + "] but was [" + paramValue.getClass().getName() + "]");
                }
                log.trace(paramName + " = " + paramValue);
            } catch (BeanUtilRuntimeException e) {
                //submit̖O(NAME)ȂǁABeanɊ֌WȂp[^
                //͖
//                log.info("p[^["+paramName+"] ̃p[^̓tH[Beañoɑ݂Ȃ̂Ŗ܂");
            }
            
        }
    }
    
    /**
     * NGXgURIɎw肳ꂽ擾܂<BR>
     * 񂪒`ĂȂ΂NULLԂ܂
     * @param path NGXgꂽURI
     * @return HashMap ̃ANV錠XgԂ܂
     */
    public HashMap getRoles(String path) {
        ActionMappings actionMappings = ActionMappings.getInstance();
        ActionMapping actionMapping = (ActionMapping) actionMappings.get(path);
        
        if (actionMapping.getRoles() == null) {
            return null;
        }
        HashMap roles = actionMapping.getRoles();
        return roles;
    }
}
