package org.itscool.weber.tag;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

import org.itscool.commons.util.JspTagUtil;

/**
 * HTML&lt;form&gt;^O𐶐^OłB<BR>
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2006/05/06
*/
public class FormTag extends HtmlBodyTag {
	protected String method;
    protected String action;
    protected String enctype;

    public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getEnctype() {
		return enctype;
	}

	public void setEnctype(String enctype) {
		this.enctype = enctype;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}
	
	public String getRealPath(String url){
		HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String contextPath = req.getContextPath();
        String realPath = contextPath + url;
    	return realPath;
	}
	
    /**
     * 
     * select^OHTMLɏo܂B<br>
     * scopew肳ĂȂꍇ́ȀŃIuWFNg܂B
     * request, session, context̏
    */
    public int doStartTag() throws JspException {
        StringBuffer inputTag = new StringBuffer("<form ");
		if(method == null || method.length() == 0 ){
			method = "POST";
		}
		action = getRealPath(action);
		
        inputTag.append(JspTagUtil.createAttribute("method", method));
        inputTag.append(JspTagUtil.createAttribute("action", action));
        inputTag.append(JspTagUtil.createAttribute("enctype", enctype));
		inputTag.append(JspTagUtil.createBoolAttribute("class", csClass));
        inputTag.append(this.createJavaScriptTag());
        inputTag.append(" >");
        
        try{
            pageContext.getOut().print(inputTag.toString());
        }catch(Exception e){
            throw new JspException(e.getMessage());
        }
        
        return EVAL_BODY_INCLUDE;
    }

    public int doEndTag() throws JspException {
        try {
            pageContext.getOut().print("</form>");
        } catch (Exception e) {
            throw new JspException(e.getMessage());
        }
        return SKIP_BODY;
    }

}
