/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.io;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.util.ServletTagUtil;
import org.itscool.stylist.io.CustConverterInitException;
import org.itscool.stylist.io.HtmlBlockTagConverter;
import org.itscool.stylist.io.HtmlCdataConverter;
import org.itscool.stylist.io.HtmlCommentConverter;
import org.itscool.stylist.io.HtmlCompareTagConverter;
import org.itscool.stylist.io.HtmlErrorInfoTagConverter;
import org.itscool.stylist.io.HtmlIncludeTagConverter;
import org.itscool.stylist.io.HtmlIsNotNullConverter;
import org.itscool.stylist.io.HtmlIsNullConverter;
import org.itscool.stylist.io.HtmlIterateTagConverter;
import org.itscool.stylist.io.HtmlSimpleTagConverter;
import org.itscool.stylist.io.HtmlTextConverter;
import org.itscool.stylist.io.HtmlWriteTagConverter;
import org.itscool.stylist.tag.HtmlTag;
import org.itscool.stylist.tag.HtmlText;

public class HtmlConverter {
    public static final String TAG_START = "${";
    public static final String TAG_END = "}";
    public static final String LINE = System.getProperty("line.separator");
    public static final String TAB = "    ";
    protected ServletContext context;
    protected HttpServletRequest req;

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public void setReq(HttpServletRequest req) {
        this.req = req;
    }

    public void init(ServletContext context, HttpServletRequest req) {
        this.context = context;
        this.req = req;
    }

    public String convert(HtmlTag node) {
        return this.convert(node, "");
    }

    public String convert(HtmlTag node, String stab) {
        StringBuffer sb = new StringBuffer();
        String tagName = node.getTagName();
        String tagKind = node.getTagKind();
        String tab = stab;
        if (tagKind.equals("tag")) {
            HtmlBlockTagConverter converter = new HtmlBlockTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab)).append(LINE);
        } else if (tagKind.equals("text")) {
            HtmlTextConverter converter = new HtmlTextConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("cdata")) {
            HtmlCdataConverter converter = new HtmlCdataConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("comment")) {
            HtmlCommentConverter converter = new HtmlCommentConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("error")) {
            HtmlErrorInfoTagConverter converter = new HtmlErrorInfoTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert()).append(LINE);
        } else if (tagKind.equals("simple")) {
            HtmlSimpleTagConverter converter = new HtmlSimpleTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("isnull")) {
            HtmlIsNullConverter converter = new HtmlIsNullConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("isnotnull")) {
            HtmlIsNotNullConverter converter = new HtmlIsNotNullConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("write")) {
            HtmlWriteTagConverter converter = new HtmlWriteTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("equal") || tagKind.equals("neq") || tagKind.equals("meq") || tagKind.equals("leq") || tagKind.equals("mthan") || tagKind.equals("lthan") || tagKind.equals("match") || tagKind.equals("nmatch")) {
            HtmlCompareTagConverter converter = new HtmlCompareTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("iterate")) {
            HtmlIterateTagConverter converter = new HtmlIterateTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab));
        } else if (tagKind.equals("include")) {
            HtmlIncludeTagConverter converter = new HtmlIncludeTagConverter();
            converter.init(this.context, this.req);
            sb.append(converter.convert(node, tab)).append(LINE);
        } else {
            BeanFactory factory = BeanFactory.getInstance();
            if (!factory.isInit()) {
                throw new CustConverterInitException("BeanFactory is not initialized.");
            }
            Object obj = factory.createInstance(tagKind);
            if (obj instanceof HtmlConverter) {
                HtmlConverter customConverter = (HtmlConverter)obj;
                if (customConverter == null) {
                    throw new CustConverterInitException("Can not create CustomConverter class  (" + tagKind + ").");
                }
                customConverter.setContext(this.context);
                customConverter.setReq(this.req);
                sb.append(customConverter.convert(node, tab)).append(LINE);
            }
        }
        return sb.toString();
    }

    public static ArrayList parseEl(String tagStr) {
        ArrayList<HtmlText> tagList = new ArrayList<HtmlText>();
        while (tagStr.length() > 0) {
            int startKey = tagStr.indexOf(TAG_START);
            int endKey = tagStr.indexOf(TAG_END);
            if (startKey > 0) {
                String value = tagStr.substring(0, startKey);
                HtmlText stag = new HtmlText();
                stag.setKind(0);
                stag.setValue(value);
                tagList.add(stag);
            } else if (startKey == -1 && tagStr.length() > 0) {
                HtmlText stag = new HtmlText();
                stag.setKind(0);
                stag.setValue(tagStr);
                tagList.add(stag);
                return tagList;
            }
            String tagValue = tagStr.substring(startKey, endKey + 1);
            HtmlText tag = new HtmlText();
            tag.setKind(1);
            tag.setValue(tagValue);
            tagList.add(tag);
            if (endKey + 1 >= tagStr.length()) {
                return tagList;
            }
            tagStr = tagStr.substring(endKey + 1, tagStr.length());
        }
        return tagList;
    }

    protected String parseText(ArrayList tagList) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < tagList.size(); ++i) {
            HtmlText tag = (HtmlText)tagList.get(i);
            if (tag.getKind() == 0) {
                sb.append(tag.getValue());
                continue;
            }
            String value = "";
            Object obj = ServletTagUtil.findValue((ServletContext)this.context, (HttpServletRequest)this.req, (String)tag.getValue(), null);
            if (obj != null) {
                value = obj.toString();
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

