/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.connection;

import java.sql.PreparedStatement;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.dao.PreparedStatementWrapper;

public class TransactionUtil {
    private static final ThreadLocal threadTransaction = new ThreadLocal();

    public static void beginTransaction() {
        TransactionUtil.getTransaction();
    }

    public static Transaction getTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        if (tx == null) {
            BeanFactory factory = BeanFactory.getInstance();
            ConnectionManager mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            tx = mgr.getTransaction();
            threadTransaction.set(tx);
        }
        return tx;
    }

    public static PreparedStatement getPreparedStatement(String sql) {
        Transaction trn = TransactionUtil.getTransaction();
        PreparedStatement pstmt = trn.getPrepareStatement(sql);
        return pstmt;
    }

    public static PreparedStatementWrapper getPreparedStatementWrapper(String sql) {
        Transaction trn = TransactionUtil.getTransaction();
        PreparedStatement pstmt = trn.getPrepareStatement(sql);
        PreparedStatementWrapper wrapper = new PreparedStatementWrapper(pstmt);
        return wrapper;
    }

    public static void commitTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            if (tx != null) {
                tx.commit();
            }
        }
        catch (TransactionException ex) {
            TransactionUtil.rollbackTransaction();
            throw ex;
        }
    }

    public static void rollbackTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        if (tx != null) {
            tx.rollback();
        }
    }

    public static void returnTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        if (tx != null) {
            BeanFactory factory = BeanFactory.getInstance();
            ConnectionManager mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            mgr.returnTransaction(tx);
        }
        threadTransaction.set(null);
    }
}

