/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.DaoRuntimeException;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.util.StringUtil;

public class RecordMapFactory {
    public static final String COLUM = "COLUM_";
    public static final String PK_COLUM = "PK_COLUM_";
    public static final String TABLE = "TABLE";

    public static RecordMap createRecordMap(String className) {
        try {
            Class<?> entity = Class.forName(className);
            return RecordMapFactory.create(entity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RecordMap createRecordMap(Class entity) {
        return RecordMapFactory.create(entity);
    }

    private static RecordMap create(Class entity) {
        Object obj = BeanUtil.createInstance(entity.getName());
        String tableName = RecordMapFactory.getTableName(entity, obj, TABLE);
        RecordMap recordMap = new RecordMap(entity.getName(), tableName);
        recordMap = RecordMapFactory.create(entity, obj, recordMap);
        HashMap records = recordMap.getFields();
        Set keySet = records.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            try {
                Object key = iterator.next();
                FieldMap fieldMap = (FieldMap)records.get(key);
                Field field = BeanUtil.getField(entity, fieldMap.getPropertyName());
                if (field == null) continue;
                String type = field.getType().getName();
                fieldMap.setType(type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recordMap;
    }

    private static RecordMap create(Class entity, Object obj, RecordMap recordMap) {
        Class superClazz = entity.getSuperclass();
        if (superClazz != null) {
            recordMap = RecordMapFactory.create(superClazz, obj, recordMap);
        }
        Field[] fields = entity.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            String staticName = field.getName();
            try {
                Class<?> type;
                String propertyName;
                String fieldName;
                FieldMap fieldMap;
                int index = staticName.indexOf(COLUM);
                int pkIndex = staticName.indexOf(PK_COLUM);
                if (modifier == 25 && pkIndex == 0) {
                    fieldMap = new FieldMap();
                    fieldName = (String)field.get(obj);
                    fieldName = fieldName.toUpperCase();
                    propertyName = staticName.substring(PK_COLUM.length(), staticName.length());
                    fieldMap.setColumName(fieldName);
                    fieldMap.setPropertyName(propertyName);
                    fieldMap.setRecordMap(recordMap);
                    fieldMap.setPrimaryKey(true);
                    recordMap.addField(fieldMap);
                    continue;
                }
                if (modifier == 25 && index == 0) {
                    fieldMap = new FieldMap();
                    fieldName = (String)field.get(obj);
                    fieldName = fieldName.toUpperCase();
                    propertyName = staticName.substring(COLUM.length(), staticName.length());
                    fieldMap.setColumName(fieldName);
                    fieldMap.setPropertyName(propertyName);
                    fieldMap.setRecordMap(recordMap);
                    fieldMap.setPrimaryKey(false);
                    recordMap.addField(fieldMap);
                    continue;
                }
                if (modifier != 2 && modifier != 4) continue;
                String fieldName2 = StringUtil.cnvUpperNameToUnderScoreName(staticName);
                fieldName2 = fieldName2.toUpperCase();
                Field check1 = null;
                Field check2 = null;
                try {
                    check1 = entity.getField(COLUM + staticName);
                    check2 = entity.getField(PK_COLUM + staticName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (recordMap.getFieldByFieldName(fieldName2) != null || check1 != null || check2 != null || !BeanUtil.isJavaType(type = field.getType())) continue;
                FieldMap fieldMap2 = new FieldMap();
                fieldName2 = fieldName2.toUpperCase();
                String propertyName2 = staticName;
                fieldMap2.setColumName(fieldName2);
                fieldMap2.setPropertyName(propertyName2);
                fieldMap2.setRecordMap(recordMap);
                if (propertyName2.equals("id")) {
                    fieldMap2.setPrimaryKey(true);
                } else {
                    fieldMap2.setPrimaryKey(false);
                }
                recordMap.addField(fieldMap2);
                continue;
            }
            catch (IllegalAccessException e) {
                String err = "[" + obj.getClass().getName() + ":" + staticName + "]" + "create() failed(" + RecordMapFactory.class.getName() + ") (" + e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
            catch (NullPointerException e) {
                String err = "[" + obj.getClass().getName() + ":" + staticName + "]" + "create() failed(" + RecordMapFactory.class.getName() + ") (" + e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
        }
        return recordMap;
    }

    protected static String getTableName(Class entity, Object obj, String tableHeaderName) {
        String tableName = entity.getName();
        try {
            Field field = BeanUtil.getField(entity, tableHeaderName);
            if (field != null) {
                tableName = (String)field.get(obj);
            } else {
                int index = tableName.lastIndexOf(".");
                int length = tableName.length();
                if (index < 0) {
                    return tableName;
                }
                tableName = tableName.substring(index + 1, length);
                tableName = StringUtil.cnvUpperNameToUnderScoreName(tableName);
                tableName = tableName.toUpperCase();
            }
        }
        catch (Exception e) {
            throw new DaoRuntimeException(e.getMessage());
        }
        return tableName;
    }

    protected static String getPropertyType(Class entity, String propertyName) {
        String propertyType = null;
        try {
            Field field = BeanUtil.getField(entity, propertyName);
            if (field != null) {
                propertyType = field.getType().getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyType;
    }

    public static void testParseClass(Class clazz) throws Exception {
        System.out.println("---------------------------");
        RecordMap record = RecordMapFactory.createRecordMap(clazz);
        System.out.println(record.getTableName() + "," + record.getClassName());
        HashMap fields = record.getFields();
        Set keySet = fields.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            System.out.println(fieldMap.getColumName() + "," + fieldMap.getPropertyName() + "," + fieldMap.getType());
        }
    }
}

