/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.action;

import java.util.HashMap;
import java.util.List;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.request.GeneralForm;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.action.Validation;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.RoleException;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserManager;

public abstract class Action {
    private HashMap lnkForwards;
    private ActionBucket bucket;
    private List validates;
    private GeneralForm generalForm = null;
    private HashMap errList = new HashMap();

    public String getForward(String name) {
        return (String)this.lnkForwards.get(name);
    }

    public void setForwards(HashMap forwards) {
        this.lnkForwards = forwards;
    }

    public void setGeneralForm(GeneralForm generalForm) {
        this.generalForm = generalForm;
    }

    public void init(ActionBucket bucket, GeneralForm generalForm) {
        this.bucket = bucket;
        this.setGeneralForm(generalForm);
    }

    public void setForm(Object bean) {
        this.bucket.setForm(bean);
    }

    public String execute() throws Exception {
        return this.doExecute(this.bucket);
    }

    public String beforeExecute() throws Exception {
        String ret = "success";
        this.beforeCheckRole();
        if (!this.checkRole(this.bucket)) {
            ret = this.doAuthFailure(this.bucket);
            return ret;
        }
        ret = this.validate(this.bucket);
        if (!ret.equals("success")) {
            this.bucket.setRetryInputParam(this.generalForm);
            return ret;
        }
        return ret;
    }

    public void putRole(String roleName) {
        this.bucket.putRole(roleName);
    }

    public void beforeCheckRole() {
    }

    public boolean checkRole(ActionBucket bucket) {
        boolean ret = true;
        if (bucket.getRoles() == null || bucket.getRoles().size() == 0) {
            return true;
        }
        User user = (User)bucket.getAttributeFromSession("org_itscool_weber_action_USER");
        if (user == null) {
            throw new RoleException();
        }
        ret = this.isUserCheck(bucket.getRoles(), user);
        return ret;
    }

    public String validate(ActionBucket bucket) throws Exception {
        Validation validation = Validation.getInstance();
        this.errList = validation.isValidate(this.validates, this.generalForm);
        if (this.isInputError()) {
            bucket.setAttribute("input_error", this.errList);
            return this.doInputFailure(bucket);
        }
        String ret = this.doValidate(bucket);
        if (this.isInputError() || !ret.equals("success")) {
            if (!this.isInputError()) {
                return ret;
            }
            bucket.setAttribute("input_error", this.errList);
            if (ret != null && ret.length() > 0) {
                return ret;
            }
            return this.doInputFailure(bucket);
        }
        return "success";
    }

    public abstract String doExecute(ActionBucket var1) throws Exception;

    protected String doValidate() throws Exception {
        return "success";
    }

    protected String doValidate(ActionBucket bucket) throws Exception {
        return this.doValidate();
    }

    protected String doAuthFailure(ActionBucket bucket) {
        return "org.itscool.weber.action.ROLE_FAIL";
    }

    protected String doInputFailure(ActionBucket bucket) {
        return "input_error";
    }

    public boolean isUserCheck(HashMap roles, User user) {
        boolean ret = false;
        BeanFactory factory = BeanFactory.getInstance();
        UserManager manager = (UserManager)factory.createInstance("UserManager");
        ret = manager.isUserCheck(roles, user);
        if (!ret) {
            throw new RoleException();
        }
        return ret;
    }

    protected void putMessage(Object key, Object msg) {
        this.errList.put(key, msg);
    }

    protected void putMessage(Object key) {
        MessageMappings messages = MessageMappings.getInstance();
        String message = (String)messages.get(key);
        this.putMessage(key, message);
    }

    public boolean isInputError() {
        boolean ret = false;
        if (this.errList.size() > 0) {
            ret = true;
        }
        return ret;
    }

    protected boolean isInt(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Integer.parseInt(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isLong(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Long.parseLong(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isDouble(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Double.parseDouble(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isFloat(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Float.parseFloat(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isShort(String paramName) {
        boolean ret = true;
        try {
            String paramValue = (String)this.getParameter(paramName);
            Short.parseShort(paramValue);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected boolean isNotNull(String paramName) {
        boolean ret = true;
        try {
            Object paramValue = this.getParameter(paramName);
            if (paramValue == null || paramValue.toString().length() == 0) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected Object getParameter(String paramName) {
        Object result = null;
        Object obj = this.generalForm.getParameter(paramName);
        return obj;
    }

    public List getValidates() {
        return this.validates;
    }

    public void setValidates(List validates) {
        this.validates = validates;
    }
}

