/*
 * TestTransaction.java
 *
 * Created on 2007/03/13, 23:23
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.connection;

import junit.framework.TestCase;
import org.itscool.commons.connection.JdbcConnectionManager;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;

/**
 *
 * @author KANO
 */
public class TestTransaction extends TestCase{
    public void setUp(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl("jdbc:hsqldb:hsql://localhost");
            mgr.setUser("sa");
            mgr.setPwd("");
            mgr.init();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testExecute(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        Transaction trn = mgr.getTransaction();
        try{
            trn.execute("DELETE FROM POST");
            
            int ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 1, 'AAA' )");
            assertEquals("insert num", 1, ret);
            
            ret = trn.execute("UPDATE POST SET NAME = 'BBB' WHERE ID = 1 ");
            assertEquals("update num", 1, ret);
            ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 2, 'AAA' )");
            assertEquals("insert num", 1, ret);
            ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 3, 'AAA' )");
            assertEquals("insert num", 1, ret);
            ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 4, 'AAA' )");
            assertEquals("insert num", 1, ret);
            
            ret = trn.execute("DELETE FROM POST");
            assertEquals("delete num", 4, ret);
            
            trn.commit();
            
        }catch(Exception e){
            fail(e.getMessage());
        }finally{
            mgr.returnTransaction(trn);
        }
    }
    
    public void testSelect(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        Transaction trn = mgr.getTransaction();
        try{
            trn.execute("DELETE FROM POST");
            
            int ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 1, 'AAA' )");
            assertEquals("insert num", 1, ret);
            ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 2, 'BBB' )");
            assertEquals("insert num", 1, ret);
            
            Records records = trn.select("SELECT ID, NAME FROM POST");
            assertEquals("record count", 2, records.size());
            
            trn.commit();
            
        }catch(Exception e){
            fail(e.getMessage());
        }finally{
            mgr.returnTransaction(trn);
        }
    }
    
    public void testSelect2(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        Transaction trn = mgr.getTransaction();
        try{
            trn.execute("DELETE FROM POST");
            
            int ret = trn.execute("INSERT INTO POST ( ID, NAME ) VALUES ( 1, 'AAA' )");
            assertEquals("insert num", 1, ret);
            
            Records records = trn.select("SELECT ID, NAME FROM POST");
            assertEquals("record count", 1, records.size());
            if(records.size() == 1){
                Record post = records.getRecord(0);
                assertEquals("post id", post.getInt("id"), 1 );
                assertEquals("post name", post.getString("name"), "AAA" );
            }
            trn.commit();
            
        }catch(Exception e){
            fail(e.getMessage());
        }finally{
            mgr.returnTransaction(trn);
        }
    }
    
    public void testExecuteFail(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        Transaction trn = mgr.getTransaction();
        try{
            trn.execute("DELETE FROM POST");
            String sql = "INSERT INTO POST ( ID   NAME ) VALUES ( 1, 'AAA' )";
            int ret = trn.execute(sql);
            assertEquals("insert num", 1, ret);
            fail("insert sql? =>" + sql);
        }catch(Exception e){
            System.out.println(e.getMessage());
        }finally{
            trn.rollback();
            mgr.returnTransaction(trn);
        }
    }
    
    public void tearDown(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        mgr.destroy();
    }
    
}
