package test.org.itscool.commons.dao.criteria;

import junit.framework.TestCase;
import org.itscool.commons.dao.*;

/**
 * 쐬: 2005/06/22
 * @author kanoum
 */
public class Criteria2Test extends TestCase{
    public Criteria2Test(String name){
        super(name);
    }
    
    public void testSelect1(){
        Criteria crt = new Criteria(BookBean1.class);
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String version = System.getProperty("java.version");
        sb.append("SELECT").append(line);
        sb.append("    BOOK.NAME as BOOK_NAME,").append(line);
        sb.append("    BOOK.AUTOR_ID as BOOK_AUTOR_ID,").append(line);
        sb.append("    BOOK.ID as BOOK_ID").append(line);
        sb.append("FROM").append(line);
        sb.append("    BOOK");
        
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelect1() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelect2(){
        Criteria crt = new Criteria(AutorBean1.class);
        
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    AUTOR.ID as AUTOR_ID,").append(line);
        sb.append("    AUTOR.NAME as AUTOR_NAME").append(line);
        sb.append("FROM").append(line);
        sb.append("    AUTOR");
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelect2() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
        
    }
    
    public void testSelect3(){
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq("autorId", 1);
        crt.or();
        crt.eq("name", "䂵");
        crt.orderby("id", true);
        crt.orderby("name", false);
        
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    BOOK.NAME as BOOK_NAME,").append(line);
        sb.append("    BOOK.AUTOR_ID as BOOK_AUTOR_ID,").append(line);
        sb.append("    BOOK.ID as BOOK_ID").append(line);
        sb.append("FROM").append(line);
        sb.append("    BOOK").append(line);
        sb.append("WHERE").append(line);
        sb.append("    BOOK.AUTOR_ID = 1").append(line);
        sb.append("    OR BOOK.NAME = '䂵'").append(line);
        sb.append("ORDER BY").append(line);
        sb.append("    BOOK.ID ASC,").append(line);
        sb.append("    BOOK.NAME DESC");
        
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelect3() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testInsert1(){
        Criteria crt = new Criteria(BookBean1.class);
        BookBean1 book = new BookBean1();
        
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO BOOK(NAME,AUTOR_ID,ID) VALUES(null,0,0)");
        
        if(!sb.toString().equals(crt.toInsertString(book))){
            System.out.println("** testInsert1() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toInsertString(book));
        }
        this.assertEquals(sb.toString(), crt.toInsertString(book));
        
    }
    
    public void testInsert(){
        BookBean1 book = new BookBean1();
        book.setName("䂵");
        book.setId(1);
        book.setAutorId(2);
        Criteria crt = new Criteria(BookBean1.class);
        crt.eq("autorId", 1);
        crt.or();
        crt.eq("name", "䂵");
        crt.orderby("id", true);
        crt.orderby("name", false);
        
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO BOOK(NAME,AUTOR_ID,ID) VALUES('䂵',2,1)");
        
        if(!sb.toString().equals(crt.toInsertString(book))){
            System.out.println("** testInsert1() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toInsertString(book));
        }
        this.assertEquals(sb.toString(), crt.toInsertString(book));
    }
    
}
