package test.org.itscool.commons.dao2;

import java.util.List;

import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.weber.testcase.WeberDbTestCase;

public class BaseDaoTest extends WeberDbTestCase{
    public void setUp(){
        this.clearTables();
        this.initTables("test/org/itscool/commons/dao2/test-db-data.xml");
    }
    
    public void testInsert(){
        Company2 company = new Company2();
        company.setId(100);
        company.setName("hoge com");
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(Company2.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            dao.insert(crt, company);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
        }catch( Exception e ){
            fail(e.getMessage());
        }
        
        try{
            if(Transaction.PLEASE_COMMIT == trn.getTranStatus()){
                TransactionUtil.commitTransaction();
            }else if(Transaction.PLEASE_ROLLBACK == trn.getTranStatus()){
                TransactionUtil.rollbackTransaction();
            }
        }catch( Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testSelect(){
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(Company2.class);
        crt.eq( Company2.COLUM_id, 1 );
        
        List list = dao.select(crt);
        assertEquals( list.size(), 1 );
        
        Company2 company = (Company2)list.get(0);
        
        assertEquals(1, company.getId());
        assertEquals("~", company.getName());
    }
    
    public void testSelect2(){
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(Customer2.class);
        crt.eq( Customer2.COLUM_id, 1 );
        
        List list = dao.select(crt);
        assertEquals( list.size(), 1 );
        
        Customer2 customer = (Customer2)list.get(0);
        
        assertEquals("ق Y", customer.getName());
        assertEquals(1, customer.getPostId());
        
        Company2 company = customer.getCompany2();
        Post2 post = customer.getPost2();
        
        assertNotNull(post);
        
        assertEquals(1, company.getId());
        assertEquals("~", company.getName());
        
        assertEquals(1, post.getId());
        assertEquals("{", post.getName());
        
    }
    
    public void testUpdate(){
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(Customer2.class);
        crt.eq( Customer2.COLUM_id, 1 );
        
        List list = dao.select(crt);
        Customer2 customer = (Customer2)list.get(0);
        Post2 post = customer.getPost2();
        
        assertNotNull(post);
        
        assertEquals(1, post.getId());
        assertEquals("{", post.getName());
        
        customer.setPostId(2);
        try{
            dao.update(crt, customer);
            TransactionUtil.commitTransaction();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testSelect3(){
        testUpdate();
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(Customer2.class);
        crt.eq( Customer2.COLUM_id, 1 );
        
        List list = dao.select(crt);
        assertEquals( list.size(), 1 );
        
        Customer2 customer = (Customer2)list.get(0);
        
        assertEquals("ق Y", customer.getName());
        assertEquals(2, customer.getPostId());
        
        Company2 company = customer.getCompany2();
        Post2 post = customer.getPost2();
        
        assertNotNull(post);
        
        assertEquals(1, company.getId());
        assertEquals("~", company.getName());
        
        assertEquals(2, post.getId());
        assertEquals("֐cƏ", post.getName());
    }
}
