package test.org.itscool.commons.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.util.StringUtil;

public class StringUtilTest extends TestCase{

    public void testEncodeHex(){
        assertEquals("sv::", "\\u3042\\u3044\\u3046\\u3048\\u304A", 
            StringUtil.encodeHex(""));
    }
    
    public void testEncodeHex2(){
        assertEquals("sv:abcdefg:", "\\u61\\u62\\u63\\u64\\u65\\u66\\u67", 
            StringUtil.encodeHex("abcdefg"));
    }
    
    public void testEncodingHex3(){
        assertEquals("sv::", "\\uFF41\\uFF42\\uFF43\\uFF44\\uFF45\\uFF46\\uFF47", 
            StringUtil.encodeHex(""));
    }
    
    public void testEncodeHex4(){
        assertEquals("sv:0123456789:", "\\u30\\u31\\u32\\u33\\u34\\u35\\u36\\u37\\u38\\u39", 
            StringUtil.encodeHex("0123456789"));
    }
    
    public void testEncodeHex5(){
        assertEquals("sv:ABCDEFG:", "\\u41\\u42\\u43\\u44\\u45\\u46\\u47", 
            StringUtil.encodeHex("ABCDEFG"));
    }
	public static Test suite() {
		return new TestSuite(StringUtilTest.class);
	}
    
}