/*
 * SqlMapper.java
 *
 * Created on 2007/04/12, 16:18
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.commons.dao;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.connection.*;
import org.itscool.commons.util.StringUtil;

/**
 *
 * @author kanou
 */
public class PreparedStatementWrapper {
    
    private PreparedStatement pstmt;
    
    public PreparedStatementWrapper(PreparedStatement pstmt) {
        //TransactionUtiloRŎ擾PreparedStatementCX^X
        //Connection.close()̃^C~OŎIɃN[Y
        this.pstmt = pstmt;
    }
    
    public void setValue(int id, String value){
        try{
            pstmt.setString(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, byte value){
        try{
            pstmt.setByte(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, short value){
        try{
            pstmt.setShort(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, int value){
        try{
            pstmt.setInt(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, long value){
        try{
            pstmt.setLong(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, double value){
        try{
            pstmt.setDouble(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, float value){
        try{
            pstmt.setFloat(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, byte[] value){
        try{
            pstmt.setBytes(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, InputStream value){
        try{
            pstmt.setBinaryStream(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, Blob value){
        try{
            pstmt.setBlob(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, Reader value){
        try{
            pstmt.setCharacterStream(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, java.util.Date value){
        try{
            java.sql.Date sqlValue = new java.sql.Date(value.getTime());
            pstmt.setDate(id, sqlValue);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    /**
     * PreparedStatementexecuteQuery()sAʃZbgŎw肵
     * IuWFNgXgŕԂ܂
     * iOQƂ1Kw܂ŁAManyToOneAOneToOne̐Lj
     */
    public List select(Class entity){
        LinkedList result = new LinkedList();
        ResultSet rs = null;
        try{
            //selects
            rs = pstmt.executeQuery();
            List recordList = createRecordList(rs);
            
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
            
            //쐬recordListBeanɃZbg
            for( int i=0; i<recordList.size(); i++){        //R[hP
                //1R[h擾
                HashMap record = (HashMap)recordList.get(i);
                //IuWFNg쐬
                Object newBean = createBean(record, gRecordMap);
                
                //֘ANX̍쐬
                Set keySet = fkRecordMaps.keySet();
                Iterator it = keySet.iterator();
                while(it.hasNext()){     //1R[h̏
                    String fkPropertyName = (String)it.next();
                    RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(fkPropertyName);
                    if( fkRecordMap == null ){
                        continue;
                    }
                    //֘AIuWFNg쐬
                    Object fkBean = createBean(record, fkRecordMap);
                    if( fkBean != null ){
                        //fkBeanZbg
                        BeanUtil.setProperty(newBean, fkPropertyName, fkBean);
                    }
                }
                
                //IuWFNgʃXgɓo^
                result.add(newBean);
            }
            return result;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }finally{
            if( rs != null ){
                try{
                    rs.close();
                }catch(Exception e){}
            }
        }
    }
    
    /**
     * ResultSetCX^X烌R[h擾A
     * e[uƂ̌ʃZbgListŕԂ܂<br>
     * <pre>
     * List recordList SR[h
     *   |
     *   +-- HashMap record PR[hiL[Fe[uj
     *          |
     *          +-- HashMap datasOfTable 1R[ȟʃZbge[uPʂŕێ
     *              iL[FJAlFIuWFNg
     * </pre>
     */
    private List createRecordList(ResultSet rs) throws SQLException {
        ArrayList recordList = new ArrayList();
        while ( rs.next() ) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashMap record = new HashMap();
            for(int i=0;i<columnCount;i++){
                String colName = metaData.getColumnName(i+1);
                String colAsName = metaData.getColumnLabel(i+1);
                String tableName = metaData.getTableName(i+1);
                //ResultSetf[^擾
                Object value = rs.getObject(i+1);
                
                //1sӂ̃e[uɊ֘Af[^}bv
                HashMap datasOfTable = (HashMap)record.get(tableName);
                if( datasOfTable == null ){
                    //System.out.println("NEW DATAS_OF_TABLE[" + tableName + "]");
                    datasOfTable = new HashMap();
                    record.put(tableName, datasOfTable);
                }
                //System.out.println("TABLE[" + tableName + "], COLUM["+colAsName +"]");
                
                datasOfTable.put(colAsName, value);
            }
            recordList.add(record);
        }
        return recordList;
    }
    
    /**
     * ʃZbgɑΉIuWFNg𐶐܂
     * @param record 1R[ȟʃZbg
     * @param recordMap NXƃe[ů֘A
     * @return ʃZbgɑΉIuWFNg
     */
    private Object createBean(HashMap record, RecordMap recordMap){
        String entityName = recordMap.getClassName();
        String tableName = recordMap.getTableName();
        HashMap datasOfTable = (HashMap)record.get(tableName);
        if( datasOfTable == null ){
            return null;
        }
        Object newBean = BeanUtil.createInstance(entityName);
        Set datasKeySet = datasOfTable.keySet();
        Iterator datasIt = datasKeySet.iterator();
        while(datasIt.hasNext()){
            String colAsName = (String)datasIt.next();
            //IuWFNg̊eoselecťʂZbgĂ
            Object value = datasOfTable.get(colAsName);
            
            //JvpeB擾
            String propertyName = StringUtil.cnvUnderScorNameToLowerName(colAsName);
            BeanUtil.setProperty(newBean, propertyName, value);
        }
        return newBean;
    }
    
    /**
     * PremeredStatement.executeQuery()̎sʂRecordsCX^X
     * Ŏ擾܂B<br>
     * <pre>
     *    Records SR[h
     *       |
     *       + RecordiHashMap) 1R[h̏
     *           iL[F"e[u.J(啶)"AlFf[^)
     * </pre>
     */
    public Records select(){
        ResultSet rs = null;
        try{
            rs = executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            Records records = new Records();
            while( rs.next() ){
                Record record = new Record();
                //ʃR[h̏WHashMapō쐬
                for(int i=0;i<columnCount;i++){
                    String colName = metaData.getColumnName(i+1);
                    String colAsName = metaData.getColumnLabel(i+1);
                    String tableName = metaData.getTableName(i+1);
                    
                    //񖼂ɕʖw肳Ăꍇ͕ʖgp
                    //Wv֐̏ꍇ͕Kʖw肷ׂł
                    if(!colAsName.equals("")){
                        colName = colAsName;
                    }
                    colName = colName.toUpperCase();
                    Object value = rs.getObject(i+1);
                    
                    //L["e[u.J"Ńf[^Zbg
                    String key = tableName + "." + colName;
                    key = key.toUpperCase();
                    record.put(key, value);
                    //record.put(colName, value);
                }
                records.add(record);
            }
            return records;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }finally{
            if( rs != null ){
                try{
                    rs.close();
                }catch(Exception e){}
            }
        }
    }
    
    /**
     * PraperdStatementexecuteQueryes܂
     * @retrun ResultSetCX^XԂ܂
     */
    public ResultSet executeQuery(){
        try{
            ResultSet ret = pstmt.executeQuery();
            return ret;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    /**
     * PraperdStatementexecuteUpdates܂
     * @return Ԃ܂
     */
    public int executeUpdate(){
        try{
            int ret = pstmt.executeUpdate();
            return ret;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
}
