package org.itscool.commons.dao;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.StringUtil;

/**
 * RecordsMp쐬NX<P>
 *
 * JavaBeans̃Ame[VǂݎAe[u}bsONXiRecordMap)
 * 𐶐郆[eBeBNXł<br>
 * JavaBeansɂ͈ȉ̃NX񂪊܂܂ĂKv܂<BR>
 * public static final TABLEŒ`ꂽe[uiȗꂽꍇ́ANX
 * e[uƂȂ܂j<BR>
 * public static final COLUM_oŒ`ꂽtB[hiȗꂽꍇ
 * ,e[uɃ}bsO܂j<BR>
 * óAJavaBeansŒ`ĂvpeBƓOgpKv
 * ܂B
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class RecordMapFactory {
    /**
     * COLUM}bsO`錾
     */
    public static final String COLUM = "COLUM_";
    
    public static final String PK_COLUM = "PK_COLUM_";
    
    /**
     * TABLE}bsO`錾
     */
    public static final String TABLE = "TABLE";
    
    /**
     * JavaBeans̃NXRecordMapCX^X𐶐܂
     * @param className iΏۂƂȂJavaBeans̃NX
     * @return RecordMapCX^X擾܂
     */
    public static RecordMap createRecordMap( String className){
        try{
            Class entity = Class.forName(className);
            return create( entity );
        }catch(ClassNotFoundException e){
            e.printStackTrace();
            return null;
        }
    }
    
    /**
     * JavaBeans̃NXRecordMapCX^X𐶐܂
     * @param entity iΏۂƂȂJavaBeans̃NX
     * @return RecordMapCX^X擾܂
     */
    public static RecordMap createRecordMap( Class entity){
        return create( entity );
    }
    
    private static RecordMap create( Class entity ){
        Object obj = BeanUtil.createInstance(entity.getName());
        String tableName = getTableName(entity, obj, TABLE);
        RecordMap recordMap = new RecordMap(entity.getName(), tableName);
        
        recordMap = create( entity, obj, recordMap );
        //-----------------------------------------------------------
        //"COLUM_o"ɑΉvpeBJavaBeansNX񂩂
        //擾܂
        //-----------------------------------------------------------
        HashMap records = recordMap.getFields();
        Set keySet = records.keySet();
        Iterator iterator = keySet.iterator();
        while( iterator.hasNext() ){
            try{
                Object key = iterator.next();
                FieldMap fieldMap = (FieldMap)records.get(key);
                //modify 2005/09/20 start
                //Field field = entity.getDeclaredField(fieldMap.getPropertyName());
                Field field = BeanUtil.getField(entity, fieldMap.getPropertyName());
                if( field == null ){
                    continue;
                }
                //modify 2005/09/20 end
                String type = field.getType().getName();
                
                fieldMap.setType(type);
            }catch(Exception e){
                e.printStackTrace();
            }
        }
        return recordMap;
    }
    
    private static RecordMap create( Class entity, Object obj, RecordMap recordMap ){
        //eNX̃o瑖
        Class superClazz = entity.getSuperclass();
        if( superClazz != null ){
            recordMap = create( superClazz, obj, recordMap );
        }
        //-------------------------------------------------------
        //RecordMapۗLeFieldMapCX^Xɑ΂
        //ΉJZbgĂ܂B
        //JZbgϐ"COLUM_vpeB"łKv܂
        //-------------------------------------------------------
        Field[] fields = entity.getDeclaredFields();
        for( int i=0; i<fields.length; i++){
            //JavaBeansɒ`ꂽtB[h擾܂
            Field field = fields[i];
            //tB[hModifier擾܂
            int modifier = field.getModifiers();
            //FieldMapCX^X쐬܂
            String staticName = field.getName();
            try{
                int index = staticName.indexOf(COLUM);
                int pkIndex = staticName.indexOf(PK_COLUM);
                if( modifier == (Modifier.PUBLIC + Modifier.STATIC + Modifier.FINAL)
                && pkIndex == 0 ){
                    FieldMap fieldMap = new FieldMap();
                    String fieldName = (String)field.get(obj);
         //add 2007/04/13 kano start
                    fieldName = fieldName.toUpperCase();
         //add 2007/04/13 kano end
                    String propertyName = staticName.substring((PK_COLUM).length(), staticName.length());
                    fieldMap.setColumName(fieldName);
                    fieldMap.setPropertyName(propertyName);
                    fieldMap.setRecordMap(recordMap);
                    fieldMap.setPrimaryKey(true);
                    recordMap.addField(fieldMap);
                }else if( modifier == (Modifier.PUBLIC + Modifier.STATIC + Modifier.FINAL)
                && index == 0 ){
                    FieldMap fieldMap = new FieldMap();
                    String fieldName = (String)field.get(obj);
         //add 2007/04/13 kano start
                    fieldName = fieldName.toUpperCase();
         //add 2007/04/13 kano end
                    String propertyName = staticName.substring((COLUM).length(), staticName.length());
                    fieldMap.setColumName(fieldName);
                    fieldMap.setPropertyName(propertyName);
                    fieldMap.setRecordMap(recordMap);
                    fieldMap.setPrimaryKey(false);
                    recordMap.addField(fieldMap);
                    
                }
                //vpeBFieldMap𐶐(COLUM`ȗΉj
                else if( modifier == Modifier.PRIVATE || modifier == Modifier.PROTECTED ){
                    String fieldName = StringUtil.cnvUpperNameToUnderScoreName(staticName);
                    fieldName = fieldName.toUpperCase();
                    Field check1=null;
                    Field check2=null;
                    try{
                        check1 = entity.getField(COLUM+staticName);
                        check2 = entity.getField(PK_COLUM+staticName);
                    }catch(Exception e){}
                    if( recordMap.getFieldByFieldName(fieldName) == null &&
                        check1 == null && check2 == null )
                        {
                        Class type = field.getType();
                        if( !BeanUtil.isJavaType(type) ){   //v~eBuyъ{f[^^iString,Date)݂̂Ώ
                            //IuWFNg^Az^͑ΏۊO
                            continue;
                        }
                        FieldMap fieldMap = new FieldMap();
                        fieldName = fieldName.toUpperCase();
                        String propertyName = staticName;
                        fieldMap.setColumName(fieldName);
                        fieldMap.setPropertyName(propertyName);
                        fieldMap.setRecordMap(recordMap);
                        if(propertyName.equals("id")){
                            fieldMap.setPrimaryKey(true);
                        }else{    
                            fieldMap.setPrimaryKey(false);
                        }
                        recordMap.addField(fieldMap);
                    }
                }
            }catch(IllegalAccessException e){
                String err = "[" + obj.getClass().getName() + ":" + staticName + "]" +
                    "create() failed(" + RecordMapFactory.class.getName() + ") (" +
                    e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }catch(NullPointerException e){
                String err = "[" + obj.getClass().getName() + ":" + staticName + "]" +
                    "create() failed(" + RecordMapFactory.class.getName() + ") (" +
                    e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
            
        }
        return recordMap;
    }
    /**
     * JavaBeansNX`e[u擾܂
     * @param entity JavaBeansNX`
     * @param obj JavaBeans琶ꂽ̃CX^X
     * @return TABEL擾܂
     */
    protected static String getTableName(Class entity, Object obj, String tableHeaderName){
        String tableName = entity.getName();
        try{
            //modify 2005/09/20 start
            //Field field = entity.getField(tableHeaderName);
            Field field = BeanUtil.getField(entity, tableHeaderName);
            //modify 2005/09/20 end
            if( field != null ){
                tableName = (String)field.get(obj);
            }else{
                //TABLE_NAMEꍇ̓NXZbg
                int index = tableName.lastIndexOf(".");
                int length = tableName.length();
                if( index < 0 ) return tableName;

                tableName = tableName.substring(index+1, length);
                tableName = StringUtil.cnvUpperNameToUnderScoreName(tableName);
                tableName = tableName.toUpperCase();
            }
        }catch(Exception e){
             throw new DaoRuntimeException(e.getMessage());
        }
        return tableName;
    }
    
    /**
     * JavaBeansNX`vpeBŎw肵vpeB̌^擾܂
     * @param entity JavaBeansNX`
     * @param propertyName vpeB
     * @return TABEL擾܂
     */
    protected static String getPropertyType(Class entity, String propertyName){
        String propertyType = null;
        try{
            //Field field = entity.getDeclaredField(propertyName);
            Field field = BeanUtil.getField(entity, propertyName);
            if( field != null ){
                propertyType = field.getType().getName();
            }
        }catch(Exception e){}
        return propertyType;
    }
    
    public static void testParseClass(Class clazz) throws Exception{
        System.out.println("---------------------------");
        RecordMap record = RecordMapFactory.createRecordMap(clazz);
        System.out.println(record.getTableName() + "," + record.getClassName());
        HashMap fields = record.getFields();
        Set keySet = fields.keySet();
        Iterator iterator = keySet.iterator();
        while( iterator.hasNext() ){
            Object key = iterator.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            System.out.println(fieldMap.getColumName()+","+fieldMap.getPropertyName()+","+fieldMap.getType());
        }
    }
    
}

